/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.fido2.api.common.FidoAppIdExtension;
import com.google.android.gms.fido.fido2.api.common.GoogleThirdPartyPaymentExtension;
import com.google.android.gms.fido.fido2.api.common.UserVerificationMethodExtension;
import com.google.android.gms.fido.fido2.api.common.zzab;
import com.google.android.gms.fido.fido2.api.common.zzad;
import com.google.android.gms.fido.fido2.api.common.zzag;
import com.google.android.gms.fido.fido2.api.common.zzai;
import com.google.android.gms.fido.fido2.api.common.zzak;
import com.google.android.gms.fido.fido2.api.common.zzaw;
import com.google.android.gms.fido.fido2.api.common.zzd;
import com.google.android.gms.fido.fido2.api.common.zzq;
import com.google.android.gms.fido.fido2.api.common.zzs;
import com.google.android.gms.fido.fido2.api.common.zzu;
import com.google.android.gms.fido.fido2.api.common.zzz;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AuthenticationExtensionsCreator")
public class AuthenticationExtensions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AuthenticationExtensions> CREATOR = new zzd();
    @SafeParcelable.Field(id=2, getter="getFidoAppIdExtension")
    @Nullable
    private final FidoAppIdExtension zza;
    @SafeParcelable.Field(id=3, getter="getCableAuthenticationExtension")
    @Nullable
    private final zzs zzb;
    @SafeParcelable.Field(id=4, getter="getUserVerificationMethodExtension")
    @Nullable
    private final UserVerificationMethodExtension zzc;
    @SafeParcelable.Field(id=5, getter="getGoogleMultiAssertionExtension")
    @Nullable
    private final zzz zzd;
    @SafeParcelable.Field(id=6, getter="getGoogleSessionIdExtension")
    @Nullable
    private final zzab zze;
    @SafeParcelable.Field(id=7, getter="getGoogleSilentVerificationExtension")
    @Nullable
    private final zzad zzf;
    @SafeParcelable.Field(id=8, getter="getDevicePublicKeyExtension")
    @Nullable
    private final zzu zzg;
    @SafeParcelable.Field(id=9, getter="getGoogleTunnelServerIdExtension")
    @Nullable
    private final zzag zzh;
    @SafeParcelable.Field(id=10, getter="getGoogleThirdPartyPaymentExtension")
    @Nullable
    private final GoogleThirdPartyPaymentExtension zzi;
    @SafeParcelable.Field(id=11, getter="getPrfExtension")
    @Nullable
    private final zzak zzj;
    @SafeParcelable.Field(id=12, getter="getSimpleTransactionAuthorizationExtension")
    @Nullable
    private final zzaw zzk;
    @SafeParcelable.Field(id=13, getter="getHmacSecretExtension")
    @Nullable
    private final zzai zzl;

    public int hashCode() {
        FidoAppIdExtension fidoAppIdExtension = this.zza;
        return Objects.hashCode((Object[])new Object[]{fidoAppIdExtension, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl});
    }

    @Nullable
    public FidoAppIdExtension getFidoAppIdExtension() {
        return this.zza;
    }

    @Nullable
    public UserVerificationMethodExtension getUserVerificationMethodExtension() {
        return this.zzc;
    }

    @NonNull
    public final String toString() {
        Object object = String.valueOf((Object)object.zza);
        String string = String.valueOf((Object)object.zzb);
        String string2 = String.valueOf((Object)object.zzc);
        String string3 = String.valueOf((Object)object.zzd);
        String string4 = String.valueOf((Object)object.zze);
        String string5 = String.valueOf((Object)object.zzf);
        String string6 = String.valueOf((Object)object.zzg);
        String string7 = String.valueOf((Object)object.zzh);
        String string8 = String.valueOf((Object)object.zzi);
        String string9 = String.valueOf((Object)object.zzj);
        String string10 = String.valueOf((Object)object.zzk);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AuthenticationExtensions{\n fidoAppIdExtension=");
        stringBuilder.append((String)object);
        stringBuilder.append(", \n cableAuthenticationExtension=");
        stringBuilder.append(string);
        stringBuilder.append(", \n userVerificationMethodExtension=");
        stringBuilder.append(string2);
        stringBuilder.append(", \n googleMultiAssertionExtension=");
        stringBuilder.append(string3);
        stringBuilder.append(", \n googleSessionIdExtension=");
        stringBuilder.append(string4);
        stringBuilder.append(", \n googleSilentVerificationExtension=");
        stringBuilder.append(string5);
        stringBuilder.append(", \n devicePublicKeyExtension=");
        stringBuilder.append(string6);
        stringBuilder.append(", \n googleTunnelServerIdExtension=");
        stringBuilder.append(string7);
        stringBuilder.append(", \n googleThirdPartyPaymentExtension=");
        stringBuilder.append(string8);
        stringBuilder.append(", \n prfExtension=");
        stringBuilder.append(string9);
        stringBuilder.append(", \n simpleTransactionAuthorizationExtension=");
        stringBuilder.append(string10);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getFidoAppIdExtension(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.zzb, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.getUserVerificationMethodExtension(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.zzd, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.zze, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.zzf, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)8, (Parcelable)this.zzg, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)9, (Parcelable)this.zzh, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)10, (Parcelable)this.zzi, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)11, (Parcelable)this.zzj, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)12, (Parcelable)this.zzk, (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, (int)13, (Parcelable)this.zzl, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@Nullable Object obj) {
        AuthenticationExtensions authenticationExtensions;
        if (!(obj instanceof AuthenticationExtensions)) {
            return false;
        }
        authenticationExtensions = authenticationExtensions;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)authenticationExtensions.zza)) && Objects.equal((Object)((Object)this.zzb), (Object)((Object)authenticationExtensions.zzb)) && Objects.equal((Object)((Object)this.zzc), (Object)((Object)authenticationExtensions.zzc)) && Objects.equal((Object)((Object)this.zzd), (Object)((Object)authenticationExtensions.zzd)) && Objects.equal((Object)((Object)this.zze), (Object)((Object)authenticationExtensions.zze)) && Objects.equal((Object)((Object)this.zzf), (Object)((Object)authenticationExtensions.zzf)) && Objects.equal((Object)((Object)this.zzg), (Object)((Object)authenticationExtensions.zzg)) && Objects.equal((Object)((Object)this.zzh), (Object)((Object)authenticationExtensions.zzh)) && Objects.equal((Object)((Object)this.zzi), (Object)((Object)authenticationExtensions.zzi)) && Objects.equal((Object)((Object)this.zzj), (Object)((Object)authenticationExtensions.zzj)) && Objects.equal((Object)((Object)this.zzk), (Object)((Object)authenticationExtensions.zzk)) && Objects.equal((Object)((Object)this.zzl), (Object)((Object)authenticationExtensions.zzl));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public static AuthenticationExtensions zza(@NonNull JSONObject jSONObject) throws JSONException {
        String string;
        Builder builder = new Builder();
        if (jSONObject.has("fidoAppIdExtension")) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("fidoAppIdExtension");
            string = "appid";
            builder.setFido2Extension(new FidoAppIdExtension(jSONObject2.getString(string)));
        }
        if (jSONObject.has("appid")) {
            String string2 = jSONObject.getString("appid");
            builder.setFido2Extension(new FidoAppIdExtension(string2));
        }
        if (jSONObject.has("prf")) {
            if (jSONObject.has("prfAlreadyHashed")) {
                throw new JSONException("both prf and prfAlreadyHashed extensions found");
            }
            builder.zzg(zzak.zza(jSONObject.getJSONObject("prf"), false));
        } else if (jSONObject.has("prfAlreadyHashed")) {
            builder.zzg(zzak.zza(jSONObject.getJSONObject("prfAlreadyHashed"), true));
        }
        if (jSONObject.has("cableAuthenticationExtension")) {
            void var1_6;
            string = jSONObject.getJSONArray("cableAuthenticationExtension");
            ArrayList<zzq> arrayList = new ArrayList<zzq>();
            boolean bl = false;
            while (var1_6 < string.length()) {
                JSONObject jSONObject3 = string.getJSONObject((int)var1_6);
                String string3 = "version";
                arrayList.add(new zzq(jSONObject3.getLong(string3), Base64.decode((String)jSONObject3.getString("clientEid"), (int)11), Base64.decode((String)jSONObject3.getString("authenticatorEid"), (int)11), Base64.decode((String)jSONObject3.getString("sessionPreKey"), (int)11)));
                ++var1_6;
            }
            builder.zza(new zzs(arrayList));
        }
        if (jSONObject.has("userVerificationMethodExtension")) {
            JSONObject jSONObject4 = jSONObject.getJSONObject("userVerificationMethodExtension");
            string = "uvm";
            builder.setUserVerificationMethodExtension(new UserVerificationMethodExtension(jSONObject4.getBoolean(string)));
        }
        if (jSONObject.has("google_multiAssertionExtension")) {
            JSONObject jSONObject5 = jSONObject.getJSONObject("google_multiAssertionExtension");
            string = "requestForMultiAssertion";
            builder.zzc(new zzz(jSONObject5.getBoolean(string)));
        }
        if (jSONObject.has("google_sessionIdExtension")) {
            JSONObject jSONObject6 = jSONObject.getJSONObject("google_sessionIdExtension");
            string = "sessionId";
            builder.zzd(new zzab(jSONObject6.getInt(string)));
        }
        if (jSONObject.has("google_silentVerificationExtension")) {
            JSONObject jSONObject7 = jSONObject.getJSONObject("google_silentVerificationExtension");
            string = "silentVerification";
            builder.zze(new zzad(jSONObject7.getBoolean(string)));
        }
        if (jSONObject.has("devicePublicKeyExtension")) {
            JSONObject jSONObject8 = jSONObject.getJSONObject("devicePublicKeyExtension");
            string = "devicePublicKey";
            builder.zzb(new zzu(jSONObject8.getBoolean(string)));
        }
        if (jSONObject.has("google_tunnelServerIdExtension")) {
            JSONObject jSONObject9 = jSONObject.getJSONObject("google_tunnelServerIdExtension");
            string = "tunnelServerId";
            builder.zzf(new zzag(jSONObject9.getString(string)));
        }
        if (jSONObject.has("google_thirdPartyPaymentExtension")) {
            JSONObject jSONObject10 = jSONObject.getJSONObject("google_thirdPartyPaymentExtension");
            string = "thirdPartyPayment";
            builder.setGoogleThirdPartyPaymentExtension(new GoogleThirdPartyPaymentExtension(jSONObject10.getBoolean(string)));
        }
        if (jSONObject.has("txAuthSimple")) {
            String string4 = "txAuthSimple";
            builder.zzh(new zzaw(jSONObject.getString(string4)));
        }
        return builder.build();
    }

    @Nullable
    public final zzs zzb() {
        return this.zzb;
    }

    @Nullable
    public final zzu zzc() {
        return this.zzg;
    }

    @Nullable
    public final zzz zzd() {
        return this.zzd;
    }

    @Nullable
    public final zzab zze() {
        return this.zze;
    }

    @Nullable
    public final zzad zzf() {
        return this.zzf;
    }

    @Nullable
    public final GoogleThirdPartyPaymentExtension zzg() {
        return this.zzi;
    }

    @Nullable
    public final zzag zzh() {
        return this.zzh;
    }

    @Nullable
    public final zzai zzi() {
        return this.zzl;
    }

    @Nullable
    public final zzak zzj() {
        return this.zzj;
    }

    @Nullable
    public final zzaw zzk() {
        return this.zzk;
    }

    @SafeParcelable.Constructor
    AuthenticationExtensions(@Nullable @SafeParcelable.Param(id=2) FidoAppIdExtension fidoAppIdExtension, @Nullable @SafeParcelable.Param(id=3) zzs zzs2, @Nullable @SafeParcelable.Param(id=4) UserVerificationMethodExtension userVerificationMethodExtension, @Nullable @SafeParcelable.Param(id=5) zzz zzz2, @Nullable @SafeParcelable.Param(id=6) zzab zzab2, @Nullable @SafeParcelable.Param(id=7) zzad zzad2, @Nullable @SafeParcelable.Param(id=8) zzu zzu2, @Nullable @SafeParcelable.Param(id=9) zzag zzag2, @Nullable @SafeParcelable.Param(id=10) GoogleThirdPartyPaymentExtension googleThirdPartyPaymentExtension, @Nullable @SafeParcelable.Param(id=11) zzak zzak2, @Nullable @SafeParcelable.Param(id=12) zzaw zzaw2, @Nullable @SafeParcelable.Param(id=13) zzai zzai2) {
        this.zza = fidoAppIdExtension;
        this.zzc = userVerificationMethodExtension;
        this.zzb = zzs2;
        this.zzd = zzz2;
        this.zze = zzab2;
        this.zzf = zzad2;
        this.zzg = zzu2;
        this.zzh = zzag2;
        this.zzi = googleThirdPartyPaymentExtension;
        this.zzj = zzak2;
        this.zzk = zzaw2;
        this.zzl = zzai2;
    }

    public static final class Builder {
        @Nullable
        private FidoAppIdExtension zza;
        @Nullable
        private UserVerificationMethodExtension zzb;
        @Nullable
        private zzs zzc;
        @Nullable
        private zzz zzd;
        @Nullable
        private zzab zze;
        @Nullable
        private zzad zzf;
        @Nullable
        private zzu zzg;
        @Nullable
        private zzag zzh;
        @Nullable
        private GoogleThirdPartyPaymentExtension zzi;
        @Nullable
        private zzak zzj;
        @Nullable
        private zzaw zzk;
        @Nullable
        private zzai zzl;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setFido2Extension(@Nullable FidoAppIdExtension appIdExtension) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGoogleThirdPartyPaymentExtension(@Nullable GoogleThirdPartyPaymentExtension googleThirdPartyPaymentExtension) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setUserVerificationMethodExtension(@Nullable UserVerificationMethodExtension userVerificationMethodExtension) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public AuthenticationExtensions build() {
            return new AuthenticationExtensions(this.zza, this.zzc, this.zzb, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl);
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@Nullable AuthenticationExtensions extensions) {
            void var1_1;
            if (var1_1 != null) {
                this.zza = var1_1.getFidoAppIdExtension();
                this.zzb = var1_1.getUserVerificationMethodExtension();
                this.zzc = var1_1.zzb();
                this.zzd = var1_1.zzd();
                this.zze = var1_1.zze();
                this.zzf = var1_1.zzf();
                this.zzg = var1_1.zzc();
                this.zzh = var1_1.zzh();
                this.zzi = var1_1.zzg();
                this.zzj = var1_1.zzj();
                this.zzk = var1_1.zzk();
                this.zzl = var1_1.zzi();
                return;
            }
        }

        public final Builder zza(@Nullable zzs zzs2) {
            this.zzc = zzs2;
            return this;
        }

        public final Builder zzb(@Nullable zzu zzu2) {
            this.zzg = zzu2;
            return this;
        }

        public final Builder zzc(@Nullable zzz zzz2) {
            this.zzd = zzz2;
            return this;
        }

        public final Builder zzd(@Nullable zzab zzab2) {
            this.zze = zzab2;
            return this;
        }

        public final Builder zze(@Nullable zzad zzad2) {
            this.zzf = zzad2;
            return this;
        }

        public final Builder zzf(@Nullable zzag zzag2) {
            this.zzh = zzag2;
            return this;
        }

        public final Builder zzg(@Nullable zzak zzak2) {
            this.zzj = zzak2;
            return this;
        }

        public final Builder zzh(@Nullable zzaw zzaw2) {
            this.zzk = zzaw2;
            return this;
        }
    }
}

