/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensionsClientOutputs;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAssertionResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAttestationResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorErrorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialType;
import com.google.android.gms.fido.fido2.api.common.zzam;
import com.google.android.gms.fido.fido2.api.common.zzao;
import com.google.android.gms.internal.fido.zzgx;
import com.google.android.gms.internal.fido.zzia;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="PublicKeyCredentialCreator")
public class PublicKeyCredential
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PublicKeyCredential> CREATOR = new zzao();
    @Nullable
    @SafeParcelable.Field(id=1, getter="getId")
    private final String zza;
    @NonNull
    @SafeParcelable.Field(id=2, getter="getType")
    private final String zzb;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getRawId", type="byte[]")
    private final zzgx zzc;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getRegisterResponse")
    private final AuthenticatorAttestationResponse zzd;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getSignResponse")
    private final AuthenticatorAssertionResponse zze;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getErrorResponse")
    private final AuthenticatorErrorResponse zzf;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getClientExtensionResults")
    private final AuthenticationExtensionsClientOutputs zzg;
    @Nullable
    @SafeParcelable.Field(id=8, getter="getAuthenticatorAttachment")
    private final String zzh;
    @Nullable
    @SafeParcelable.Field(id=9, getter="getJsonString")
    private String zzi;

    public int hashCode() {
        String string = this.zza;
        return Objects.hashCode((Object[])new Object[]{string, this.zzb, this.zzc, this.zze, this.zzd, this.zzf, this.zzg, this.zzh});
    }

    @Nullable
    public AuthenticationExtensionsClientOutputs getClientExtensionResults() {
        return this.zzg;
    }

    @NonNull
    public AuthenticatorResponse getResponse() {
        AuthenticatorResponse authenticatorResponse = this_.zzd;
        if (authenticatorResponse != null) {
            return authenticatorResponse;
        }
        authenticatorResponse = this_.zze;
        if (authenticatorResponse != null) {
            return authenticatorResponse;
        }
        AbstractSafeParcelable this_ = this_.zzf;
        if (this_ == null) {
            throw new IllegalStateException("No response set.");
        }
        return this_;
    }

    @NonNull
    public static PublicKeyCredential deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (PublicKeyCredential)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @Nullable
    public String getAuthenticatorAttachment() {
        return this.zzh;
    }

    @Nullable
    public String getId() {
        return this.zza;
    }

    @NonNull
    public String getType() {
        return this.zzb;
    }

    @NonNull
    public String toJson() {
        return this.zza().toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public final String toString() {
        Object object = this.zzc;
        object = object == null ? null : (Object)((zzgx)object).zzm();
        String string = this.zzb;
        String string2 = this.zza;
        AuthenticatorAttestationResponse authenticatorAttestationResponse = this.zzd;
        AuthenticatorAssertionResponse authenticatorAssertionResponse = this.zze;
        AuthenticatorErrorResponse authenticatorErrorResponse = this.zzf;
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = this.zzg;
        String string3 = Base64Utils.encodeUrlSafeNoPadding((byte[])object);
        object = String.valueOf((Object)authenticatorAttestationResponse);
        String string4 = String.valueOf((Object)authenticatorAssertionResponse);
        String string5 = String.valueOf((Object)authenticatorErrorResponse);
        String string6 = String.valueOf((Object)authenticationExtensionsClientOutputs);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PublicKeyCredential{\n id='");
        stringBuilder.append(string2);
        stringBuilder.append("', \n type='");
        stringBuilder.append(string);
        stringBuilder.append("', \n rawId=");
        stringBuilder.append(string3);
        stringBuilder.append(", \n registerResponse=");
        stringBuilder.append((String)object);
        stringBuilder.append(", \n signResponse=");
        stringBuilder.append(string4);
        stringBuilder.append(", \n errorResponse=");
        stringBuilder.append(string5);
        stringBuilder.append(", \n extensionsClientOutputs=");
        stringBuilder.append(string6);
        stringBuilder.append(", \n authenticatorAttachment='");
        stringBuilder.append(this.zzh);
        stringBuilder.append("'}");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    PublicKeyCredential(@Nullable @SafeParcelable.Param(id=1) String string, @NonNull @SafeParcelable.Param(id=2) String string2, @Nullable @SafeParcelable.Param(id=3) byte[] object, @Nullable @SafeParcelable.Param(id=4) AuthenticatorAttestationResponse authenticatorAttestationResponse, @Nullable @SafeParcelable.Param(id=5) AuthenticatorAssertionResponse authenticatorAssertionResponse, @Nullable @SafeParcelable.Param(id=6) AuthenticatorErrorResponse authenticatorErrorResponse, @Nullable @SafeParcelable.Param(id=7) AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs, @Nullable @SafeParcelable.Param(id=8) String string3, @Nullable @SafeParcelable.Param(id=9) String string4) {
        void var9_12;
        void var8_11;
        void var7_10;
        void var6_9;
        void var5_8;
        void var4_7;
        void var3_5;
        if (object == null) {
            Object var3_4 = null;
        } else {
            zzgx zzgx2 = zzgx.zzl(object, 0, ((byte[])object).length);
        }
        this(string, string2, (zzgx)var3_5, (AuthenticatorAttestationResponse)var4_7, (AuthenticatorAssertionResponse)var5_8, (AuthenticatorErrorResponse)var6_9, (AuthenticationExtensionsClientOutputs)var7_10, (String)var8_11, (String)var9_12);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        if (zzia.zzc()) {
            this.zzi = this.zza().toString();
        }
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getType(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)3, (byte[])this.getRawId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.zzd, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.zze, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.zzf, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.getClientExtensionResults(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.getAuthenticatorAttachment(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)9, (String)this.zzi, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
        this.zzi = null;
    }

    public boolean equals(@Nullable Object obj) {
        PublicKeyCredential publicKeyCredential;
        if (!(obj instanceof PublicKeyCredential)) {
            return false;
        }
        publicKeyCredential = publicKeyCredential;
        return Objects.equal((Object)this.zza, (Object)publicKeyCredential.zza) && Objects.equal((Object)this.zzb, (Object)publicKeyCredential.zzb) && Objects.equal((Object)this.zzc, (Object)publicKeyCredential.zzc) && Objects.equal((Object)((Object)this.zzd), (Object)((Object)publicKeyCredential.zzd)) && Objects.equal((Object)((Object)this.zze), (Object)((Object)publicKeyCredential.zze)) && Objects.equal((Object)((Object)this.zzf), (Object)((Object)publicKeyCredential.zzf)) && Objects.equal((Object)((Object)this.zzg), (Object)((Object)publicKeyCredential.zzg)) && Objects.equal((Object)this.zzh, (Object)publicKeyCredential.zzh);
    }

    @Nullable
    public byte[] getRawId() {
        zzgx this_ = ((PublicKeyCredential)((Object)this_)).zzc;
        if (this_ == null) {
            return null;
        }
        return this_.zzm();
    }

    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    @Nullable
    public zzgx getRawIdAsByteString() {
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        boolean bl;
        String string;
        Object object;
        JSONObject jSONObject;
        block10: {
            block11: {
                try {
                    Object object2;
                    int n;
                    jSONObject = new JSONObject();
                    object = this.zzc;
                    if (object != null && (n = ((zzgx)object).zzm().length) > 0) {
                        jSONObject.put("rawId", (Object)Base64Utils.encodeUrlSafeNoPadding((byte[])this.zzc.zzm()));
                    }
                    if ((object = this.zzh) != null) {
                        object2 = "authenticatorAttachment";
                        jSONObject.put(object2, object);
                    }
                    if ((object = this.zzb) != null && (object2 = this.zzf) == null) {
                        object2 = "type";
                        jSONObject.put(object2, object);
                    }
                    if ((object = this.zza) != null) {
                        object2 = "id";
                        jSONObject.put(object2, object);
                    }
                    string = "response";
                    object = this.zze;
                    if (object != null) {
                        object = ((AuthenticatorAssertionResponse)((Object)object)).zza();
                        bl = true;
                        break block10;
                    }
                    object = this.zzd;
                    if (object != null) {
                        object = ((AuthenticatorAttestationResponse)((Object)object)).zza();
                        bl = true;
                        break block10;
                    }
                    object = this.zzf;
                    if (object == null) break block11;
                    object = ((AuthenticatorErrorResponse)((Object)object)).zza();
                    string = "error";
                    bl = false;
                    break block10;
                }
                catch (JSONException jSONException) {
                    throw new RuntimeException("Error encoding PublicKeyCredential to JSON object", jSONException);
                }
            }
            object = null;
            bl = false;
        }
        if (object != null) {
            jSONObject.put(string, object);
        }
        if ((this = this.zzg) != null) {
            object = "clientExtensionResults";
            jSONObject.put((String)object, (Object)this.zza());
            return jSONObject;
        }
        if (!bl) return jSONObject;
        jSONObject.put("clientExtensionResults", (Object)new JSONObject());
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private PublicKeyCredential(@Nullable String string, @NonNull String string2, @Nullable zzgx zzgx2, @Nullable AuthenticatorAttestationResponse authenticatorAttestationResponse, @Nullable AuthenticatorAssertionResponse authenticatorAssertionResponse, @Nullable AuthenticatorErrorResponse authenticatorErrorResponse, @Nullable AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs, @Nullable String string3, @Nullable String string4) {
        boolean bl = authenticatorAttestationResponse == null || authenticatorAssertionResponse != null || authenticatorErrorResponse != null ? (authenticatorAttestationResponse != null || authenticatorAssertionResponse == null || authenticatorErrorResponse != null ? (authenticatorAttestationResponse == null ? (authenticatorAssertionResponse == null ? authenticatorErrorResponse != null : false) : false) : true) : true;
        Preconditions.checkArgument((boolean)bl, (Object)"Must provide a response object.");
        bl = authenticatorErrorResponse == null ? (string != null ? zzgx2 != null : false) : true;
        Preconditions.checkArgument((boolean)bl, (Object)"Must provide id and rawId if not an error response.");
        this.zza = string;
        this.zzb = string2;
        this.zzc = zzgx2;
        this.zzd = authenticatorAttestationResponse;
        this.zze = authenticatorAssertionResponse;
        this.zzf = authenticatorErrorResponse;
        this.zzg = authenticationExtensionsClientOutputs;
        this.zzh = string3;
        this.zzi = null;
    }

    /* synthetic */ PublicKeyCredential(String string, String string2, zzgx zzgx2, AuthenticatorAttestationResponse authenticatorAttestationResponse, AuthenticatorAssertionResponse authenticatorAssertionResponse, AuthenticatorErrorResponse authenticatorErrorResponse, AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs, String string3, String string4, zzam zzam2) {
        this(string, string2, zzgx2, authenticatorAttestationResponse, authenticatorAssertionResponse, authenticatorErrorResponse, authenticationExtensionsClientOutputs, string3, null);
    }

    public static class Builder {
        @Nullable
        private String zza;
        @Nullable
        private zzgx zzb;
        private AuthenticatorResponse zzc;
        @Nullable
        private AuthenticationExtensionsClientOutputs zzd;
        @Nullable
        private String zze;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticationExtensionsClientOutputs(@Nullable AuthenticationExtensionsClientOutputs extensionsClientOutputs) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticatorAttachment(@Nullable String authenticatorAttachment) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setId(@Nullable String id) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setRawId(@Nullable byte[] rawId) {
            zzgx zzgx2;
            if (rawId == null) {
                zzgx2 = null;
            } else {
                zzgx zzgx3 = zzgx2;
                zzgx2 = zzgx.zzl(zzgx3, 0, (zzgx3).length);
            }
            this.zzb = zzgx2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setResponse(@NonNull AuthenticatorResponse response) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public PublicKeyCredential build() {
            AuthenticatorResponse authenticatorResponse = this.zzc;
            AuthenticatorAttestationResponse authenticatorAttestationResponse = authenticatorResponse instanceof AuthenticatorAttestationResponse ? (AuthenticatorAttestationResponse)authenticatorResponse : null;
            AuthenticatorAssertionResponse authenticatorAssertionResponse = authenticatorResponse instanceof AuthenticatorAssertionResponse ? (AuthenticatorAssertionResponse)authenticatorResponse : null;
            if (authenticatorResponse instanceof AuthenticatorErrorResponse) {
                authenticatorResponse = (AuthenticatorErrorResponse)authenticatorResponse;
                return new PublicKeyCredential(this.zza, PublicKeyCredentialType.PUBLIC_KEY.toString(), this.zzb, authenticatorAttestationResponse, authenticatorAssertionResponse, (AuthenticatorErrorResponse)authenticatorResponse, this.zzd, this.zze, null, null);
            }
            authenticatorResponse = null;
            return new PublicKeyCredential(this.zza, PublicKeyCredentialType.PUBLIC_KEY.toString(), this.zzb, authenticatorAttestationResponse, authenticatorAssertionResponse, (AuthenticatorErrorResponse)authenticatorResponse, this.zzd, this.zze, null, null);
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRawId(@Nullable zzgx rawId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }
    }
}

