/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.fido.fido2.api.common.zzal;
import com.google.android.gms.internal.fido.zzfv;
import com.google.android.gms.internal.fido.zzfx;
import com.google.android.gms.internal.fido.zzgj;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="PrfExtensionCreator")
public final class zzak
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzak> CREATOR = new zzal();
    private static final byte[] zza = "WebAuthn PRF\u0000".getBytes(StandardCharsets.UTF_8);
    @SafeParcelable.Field(id=1, getter="getEvaluationPoints")
    private final byte[][] zzb;

    public final int hashCode() {
        byte[][] byArray = this.zzb;
        int n = byArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = byArray[i];
            if (byArray2 == null) continue;
            n2 ^= Objects.hashCode((Object[])new Object[]{byArray2});
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzak zza(JSONObject jSONObject, boolean bl) throws JSONException {
        ArrayList<byte[]> arrayList;
        block8: {
            arrayList = new ArrayList<byte[]>();
            try {
                boolean bl2;
                boolean bl3 = jSONObject.has("eval");
                if (bl3) {
                    arrayList.add(null);
                    if (bl) {
                        arrayList.add(zzak.zzd(jSONObject.getJSONObject("eval")));
                    } else {
                        arrayList.add(zzak.zze(jSONObject.getJSONObject("eval")));
                    }
                }
                if (!(bl3 = jSONObject.has("evalByCredential"))) break block8;
                jSONObject = jSONObject.getJSONObject("evalByCredential");
                Iterator iterator = jSONObject.keys();
                while (bl2 = iterator.hasNext()) {
                    String string = (String)iterator.next();
                    arrayList.add(Base64Utils.decodeUrlSafeNoPadding((String)string));
                    if (bl) {
                        arrayList.add(zzak.zzd(jSONObject.getJSONObject(string)));
                        continue;
                    }
                    arrayList.add(zzak.zze(jSONObject.getJSONObject(string)));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JSONException("invalid base64url value");
            }
        }
        return new zzak((byte[][])arrayList.toArray((T[])new byte[0][]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String toString() {
        try {
            Object object;
            int n;
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = null;
            for (int i = 0; i < (n = ((byte[][])(object = this /* !! */ .zzb)).length); i += 2) {
                Object object2 = object[i];
                if (object2 == null) {
                    object2 = "eval";
                    int n2 = i + 1;
                    object = object[n2];
                    jSONObject.put((String)object2, (Object)zzak.zzb((byte[])object));
                    continue;
                }
                if (jSONObject2 == null) {
                    jSONObject2 = new JSONObject();
                    jSONObject.put("evalByCredential", (Object)jSONObject2);
                }
                object = this /* !! */ .zzb[i];
                object = Base64Utils.encodeUrlSafeNoPadding((byte[])object);
                object2 = this /* !! */ .zzb[i + 1];
                jSONObject2.put((String)object, (Object)zzak.zzb(object2));
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PrfExtension{");
            stringBuilder.append(jSONObject.toString());
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        catch (JSONException jSONException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PrfExtension{Exception:");
            stringBuilder.append(jSONException.getMessage());
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JSONObject zzb(byte[] object) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (((byte[])object).length == 32) {
            String string = Base64Utils.encodeUrlSafeNoPadding((byte[])object);
            jSONObject.put("first", (Object)string);
            return jSONObject;
        }
        String string = Base64.encodeToString((byte[])object, (int)0, (int)32, (int)11);
        jSONObject.put("first", (Object)string);
        String string2 = Base64.encodeToString((byte[])object, (int)32, (int)32, (int)11);
        jSONObject.put("second", (Object)string2);
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public zzak(@SafeParcelable.Param(id=1) byte[][] byArray) {
        int n = byArray != null ? 1 : 0;
        Preconditions.checkArgument(n != 0);
        n = 1 != (byArray.length & 1 ^ 1) ? 0 : 1;
        Preconditions.checkArgument(n != 0);
        n = 0;
        while (true) {
            if (n >= byArray.length) {
                this.zzb = byArray;
                return;
            }
            boolean bl = n != 0 ? byArray[n] != null : true;
            Preconditions.checkArgument((boolean)bl);
            int n2 = n + 1;
            bl = byArray[n2] != null;
            Preconditions.checkArgument((boolean)bl);
            bl = byArray[n2].length;
            bl = !bl ? bl : true;
            Preconditions.checkArgument((boolean)bl);
            n += 2;
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Object object = object.zzb;
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeByteArrayArray((Parcel)parcel2, (int)1, (byte[][])object, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)SafeParcelWriter.beginObjectHeader((Parcel)parcel));
    }

    public final boolean equals(Object object) {
        if (!(object instanceof zzak)) {
            return false;
        }
        object = (zzak)((Object)object);
        return Arrays.deepEquals((Object[])this.zzb, (Object[])((zzak)((Object)object)).zzb);
    }

    private static byte[] zzc(byte[] byArray) {
        zzfv zzfv2 = zzfx.zza().zza();
        zzfv2.zza(zza);
        zzfv2.zza(byArray);
        return zzfv2.zzc().zzd();
    }

    private static byte[] zzd(JSONObject object) throws JSONException {
        byte[] byArray = Base64Utils.decodeUrlSafeNoPadding((String)object.getString("first"));
        if (byArray.length != 32) {
            throw new JSONException("hashed PRF value with wrong length");
        }
        if (!object.has("second")) {
            return byArray;
        }
        if (((JSONObject)(object = (Object)Base64Utils.decodeUrlSafeNoPadding((String)object.getString("second")))).length != 32) {
            throw new JSONException("hashed PRF value with wrong length");
        }
        return zzgj.zza(byArray, (byte[])object);
    }

    private static byte[] zze(JSONObject jSONObject) throws JSONException {
        byte[] byArray = zzak.zzc(Base64Utils.decodeUrlSafeNoPadding((String)jSONObject.getString("first")));
        if (!jSONObject.has("second")) {
            return byArray;
        }
        return zzgj.zza(byArray, zzak.zzc(Base64Utils.decodeUrlSafeNoPadding((String)jSONObject.getString("second"))));
    }
}

