/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zze;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@SafeParcelable.Class(creator="KeyHandleCreator")
public class KeyHandle
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zze();
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getBytes")
    private final byte[] zzb;
    @SafeParcelable.Field(id=3, getter="getProtocolVersionAsString", type="java.lang.String")
    private final ProtocolVersion zzc;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getTransports")
    private final List zzd;

    public int getVersionCode() {
        return this.zza;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.zzb), this.zzc, this.zzd});
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static KeyHandle parseFromJson(@NonNull JSONObject registeredKey) throws JSONException {
        void var0_2;
        ProtocolVersion protocolVersion;
        JSONObject jSONObject;
        if (registeredKey.has("version")) {
            String string = jSONObject.getString("version");
        } else {
            Object var1_9 = null;
        }
        try {
            void var1_7;
            protocolVersion = ProtocolVersion.fromString((String)var1_7);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        Object object = jSONObject.getString("keyHandle");
        try {
            object = Base64.decode((String)object, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        if (!jSONObject.has("transports")) {
            return new KeyHandle((byte[])object, protocolVersion, (List<Transport>)var0_2);
        }
        List<Transport> list = Transport.parseTransports(jSONObject.getJSONArray("transports"));
        return new KeyHandle((byte[])object, protocolVersion, (List<Transport>)var0_2);
    }

    @NonNull
    public ProtocolVersion getProtocolVersion() {
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        Object object = this.zzd;
        object = object == null ? "null" : object.toString();
        byte[] byArray = this.zzb;
        Object[] objectArray = new Object[]{Base64Utils.encode((byte[])byArray), this.zzc, object};
        return String.format("{keyHandle: %s, version: %s, transports: %s}", objectArray);
    }

    @NonNull
    public List<Transport> getTransports() {
        return this.zzd;
    }

    @NonNull
    public JSONObject toJson() {
        return this.zza();
    }

    /*
     * WARNING - void declaration
     */
    public KeyHandle(@NonNull byte[] keyHandleBytes, @NonNull ProtocolVersion protocolVersion, @Nullable List<Transport> transports) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = 1;
        this.zzb = var1_1;
        this.zzc = var2_2;
        this.zzd = var3_3;
    }

    @SafeParcelable.Constructor
    KeyHandle(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) byte[] byArray, @SafeParcelable.Param(id=3) String string, @Nullable @SafeParcelable.Param(id=4) List list) {
        this.zza = n;
        this.zzb = byArray;
        try {
            this.zzc = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzd = list;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getVersionCode());
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)2, (byte[])this.getBytes(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzc.toString(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeTypedList((Parcel)v1, (int)4, this.getTransports(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@NonNull Object obj) {
        KeyHandle keyHandle;
        if (this == keyHandle) {
            return true;
        }
        if (!(keyHandle instanceof KeyHandle)) {
            return false;
        }
        keyHandle = keyHandle;
        if (!Arrays.equals(this.zzb, keyHandle.zzb)) {
            return false;
        }
        if (!this.zzc.equals((Object)keyHandle.zzc)) {
            return false;
        }
        List list = this.zzd;
        if (list != null || keyHandle.zzd != null) {
            List list2;
            if (list == null || (list2 = keyHandle.zzd) == null) {
                return false;
            }
            return list.containsAll(list2) && keyHandle.zzd.containsAll(this.zzd);
        }
        return true;
    }

    @NonNull
    public byte[] getBytes() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            Object object = ((KeyHandle)((Object)iterator)).zzb;
            if (object != null) {
                string = "keyHandle";
                jSONObject.put(string, (Object)Base64.encodeToString((byte[])object, (int)11));
            }
            if ((object = (Object)((Object)((KeyHandle)((Object)iterator)).zzc)) != null) {
                string = "version";
                jSONObject.put(string, (Object)((ProtocolVersion)((Object)object)).toString());
            }
            if ((object = (Object)((KeyHandle)((Object)iterator)).zzd) == null) return jSONObject;
            object = new JSONArray();
            Iterator iterator = ((KeyHandle)((Object)iterator)).zzd.iterator();
            while (true) {
                boolean bl;
                if (!(bl = iterator.hasNext())) {
                    jSONObject.put("transports", object);
                    return jSONObject;
                }
                object.put((Object)((Transport)((Object)iterator.next())).toString());
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

