/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.zzn;
import com.google.android.gms.internal.zzanl;
import com.google.android.gms.internal.zzaph;

public final class Device
extends zza {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final int versionCode;
    private final String zzaRL;
    private final String zzaRM;
    private final String version;
    private final String zzaRN;
    private final int type;
    private final int zzaRO;
    public static final Parcelable.Creator<Device> CREATOR = new zzn();

    public static Device getLocalDevice(Context context) {
        int n = zzanl.zzaX(context);
        String string = Device.zzaV(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzaV(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    public Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(1, string, string2, "", string4, n, n2);
    }

    Device(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        this.versionCode = n;
        this.zzaRL = (String)zzac.zzw((Object)string);
        this.zzaRM = (String)zzac.zzw((Object)string2);
        this.version = "";
        this.zzaRN = this.zzec(string4);
        this.type = n2;
        this.zzaRO = n3;
    }

    private String zzec(String string) {
        if (string != null) {
            return string;
        }
        throw new IllegalStateException("Device UID is null.");
    }

    public String getManufacturer() {
        return this.zzaRL;
    }

    public String getModel() {
        return this.zzaRM;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUid() {
        return this.zzaRN;
    }

    public int getType() {
        return this.type;
    }

    public int zzBy() {
        return this.zzaRO;
    }

    private boolean zzBz() {
        return this.zzBy() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzaRL, this.zzaRM, this.zzaRN);
    }

    public String zzBA() {
        return this.zzBz() ? this.zzaRN : zzaph.zzeo(this.zzaRN);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.version, this.type, this.zzaRO);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Device && this.zza((Device)((Object)object));
    }

    private boolean zza(Device device) {
        return zzaa.equal((Object)this.zzaRL, (Object)device.zzaRL) && zzaa.equal((Object)this.zzaRM, (Object)device.zzaRM) && zzaa.equal((Object)this.version, (Object)device.version) && zzaa.equal((Object)this.zzaRN, (Object)device.zzaRN) && this.type == device.type && this.zzaRO == device.zzaRO;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaRL, this.zzaRM, this.version, this.zzaRN, this.type});
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzn.zza(this, parcel, n);
    }
}

