/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
extends zza
implements Result {
    private final int mVersionCode;
    private final List<Subscription> zzaWz;
    private final Status zzahq;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzo();

    ListSubscriptionsResult(int n, List<Subscription> list, Status status) {
        this.mVersionCode = n;
        this.zzaWz = list;
        this.zzahq = status;
    }

    public ListSubscriptionsResult(List<Subscription> list, Status status) {
        this.mVersionCode = 3;
        this.zzaWz = Collections.unmodifiableList(list);
        this.zzahq = (Status)zzac.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzag(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzaWz;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzaWz) {
            if (!dataType.equals((Object)subscription.zzBL())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzahq;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)((Object)object));
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzahq.equals((Object)listSubscriptionsResult.zzahq) && zzaa.equal(this.zzaWz, listSubscriptionsResult.zzaWz);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzahq, this.zzaWz});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("status", (Object)this.zzahq).zzg("subscriptions", this.zzaWz).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }
}

