/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<DailyTotalResult> readDailyTotalFromLocalDevice(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public PendingResult<Status> updateData(GoogleApiClient var1, DataUpdateRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<Status> registerDataUpdateListener(GoogleApiClient var1, DataUpdateListenerRegistrationRequest var2);

    public PendingResult<Status> unregisterDataUpdateListener(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context zzqr;
        private final DataType zzaQI;
        private DataSource zzaQJ;
        private long zzaIZ;
        private long zzaJa;
        private String zzaQK;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.zzqr = context;
            this.zzaQI = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzaIZ = timeUnit.toMillis(l);
            this.zzaJa = timeUnit.toMillis(l2);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzac.zzb((boolean)dataSource.getDataType().equals((Object)this.zzaQI), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzaQI});
            this.zzaQJ = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String string) {
            this.zzaQK = string;
            return this;
        }

        public Intent build() {
            zzac.zza((this.zzaIZ > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzac.zza((this.zzaJa > this.zzaIZ ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzaQJ.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzaIZ);
            intent.putExtra("vnd.google.fitness.end_time", this.zzaJa);
            zzd.zza((SafeParcelable)this.zzaQJ, (Intent)intent, (String)"vnd.google.fitness.data_source");
            return this.zzk(intent);
        }

        private Intent zzk(Intent intent) {
            if (this.zzaQK == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzaQK);
            ResolveInfo resolveInfo = this.zzqr.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzaQK, string));
                return intent2;
            }
            return intent;
        }
    }
}

