/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends zza
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int mVersionCode;
    private final long zzaed;
    private final long zzaQV;
    private final Session zzaQL;
    private final int zzaQW;
    private final List<DataSet> zzaQX;
    private final int zzaQY;
    private boolean zzaQZ = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.mVersionCode = n;
        this.zzaed = l;
        this.zzaQV = l2;
        this.zzaQL = session;
        this.zzaQW = n2;
        this.zzaQX = list;
        this.zzaQY = n3;
        this.zzaQZ = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.zzaed, rawBucket.zzaQV, rawBucket.zzaQL, rawBucket.zzaTz, Bucket.zza(rawBucket.zzaQX, list), rawBucket.zzaQY, rawBucket.zzaQZ);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaed, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaQV, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzaQL;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzaQW);
    }

    public int zzBg() {
        return this.zzaQW;
    }

    public List<DataSet> getDataSets() {
        return this.zzaQX;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaQX) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzaQY;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Bucket && this.zza((Bucket)((Object)object));
    }

    private boolean zza(Bucket bucket) {
        return this.zzaed == bucket.zzaed && this.zzaQV == bucket.zzaQV && this.zzaQW == bucket.zzaQW && zzaa.equal(this.zzaQX, bucket.zzaQX) && this.zzaQY == bucket.zzaQY && this.zzaQZ == bucket.zzaQZ;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzaed == bucket.zzaed && this.zzaQV == bucket.zzaQV && this.zzaQW == bucket.zzaQW && this.zzaQY == bucket.zzaQY;
    }

    public boolean zzBh() {
        if (this.zzaQZ) {
            return true;
        }
        for (DataSet dataSet : this.zzaQX) {
            if (!dataSet.zzBh()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaed, this.zzaQV, this.zzaQW, this.zzaQY});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTime", (Object)this.zzaed).zzg("endTime", (Object)this.zzaQV).zzg("activity", (Object)this.zzaQW).zzg("dataSets", this.zzaQX).zzg("bucketType", (Object)Bucket.zzgn(this.zzaQY)).zzg("serverHasMoreData", (Object)this.zzaQZ).toString();
    }

    public static String zzgn(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzpN() {
        return this.zzaed;
    }

    public long zzzx() {
        return this.zzaQV;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }
}

