/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzang;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzaQJ;
    private long zzaRc;
    private long zzaRd;
    private final Value[] zzaRe;
    private DataSource zzaRf;
    private long zzaRg;
    private long zzaRh;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzh();

    DataPoint(int n, DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.versionCode = n;
        this.zzaQJ = dataSource;
        this.zzaRf = dataSource2;
        this.zzaRc = l;
        this.zzaRd = l2;
        this.zzaRe = valueArray;
        this.zzaRg = l3;
        this.zzaRh = l4;
    }

    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zzc(list, rawDataPoint.zzaTD), DataPoint.zzc(list, rawDataPoint.zzaTE), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzaTA, 0L), DataPoint.zza(rawDataPoint.zzaTB, 0L), rawDataPoint.zzaTC, dataSource2, DataPoint.zza(rawDataPoint.zzaTF, 0L), DataPoint.zza(rawDataPoint.zzaTG, 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.versionCode = 4;
        this.zzaQJ = (DataSource)((Object)zzac.zzb((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzaRe = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzaRe[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzd.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzaRc = timeUnit.toNanos(l);
        if (this.zzBj() && zzang.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzaRc = zzang.zza(this.zzaRc, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzBj() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzaRd = timeUnit.toNanos(l);
        this.zzaRc = timeUnit.toNanos(l2);
        return this;
    }

    public Value zzgp(int n) {
        DataType dataType = this.getDataType();
        if (n < 0 || n >= dataType.getFields().size()) {
            throw new IllegalArgumentException(String.format("fieldIndex %s is out of range for %s", new Object[]{n, dataType}));
        }
        return this.zzaRe[n];
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzaRe[n];
    }

    public Value[] zzBk() {
        return this.zzaRe;
    }

    public DataPoint setFloatValues(float ... fArray) {
        this.zzgq(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzaRe[i].setFloat(fArray[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... nArray) {
        this.zzgq(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzaRe[i].setInt(nArray[i]);
        }
        return this;
    }

    private void zzgq(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzac.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzaQJ.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzaQJ;
    }

    public DataSource getOriginalDataSource() {
        return this.zzaRf != null ? this.zzaRf : this.zzaQJ;
    }

    public DataSource zzBl() {
        return this.zzaRf;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaRc, TimeUnit.NANOSECONDS);
    }

    public long zzBm() {
        return this.zzaRg;
    }

    public long zzBn() {
        return this.zzaRh;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaRd, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaRc, TimeUnit.NANOSECONDS);
    }

    public void zzBo() {
        DataSource dataSource = this.getDataSource();
        zzac.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzac.zzb((this.zzaRc > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzac.zzb((this.zzaRd <= this.zzaRc ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataPoint && this.zzc((DataPoint)((Object)object));
    }

    private boolean zzc(DataPoint dataPoint) {
        return zzaa.equal((Object)((Object)this.zzaQJ), (Object)((Object)dataPoint.zzaQJ)) && this.zzaRc == dataPoint.zzaRc && this.zzaRd == dataPoint.zzaRd && Arrays.equals((Object[])this.zzaRe, (Object[])dataPoint.zzaRe) && zzaa.equal((Object)((Object)this.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource()));
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaQJ, this.zzaRc, this.zzaRd});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzaRe), this.zzaRd, this.zzaRc, this.zzaRg, this.zzaRh, this.zzaQJ.toDebugString(), this.zzaRf != null ? this.zzaRf.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public long getTimestampNanos() {
        return this.zzaRc;
    }

    public long zzBp() {
        return this.zzaRd;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

