/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.data.zzj;

public class DataSource
extends zza {
    private static final int[] zzaRl = new int[0];
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int versionCode;
    private final DataType zzaQI;
    private final String name;
    private final int type;
    private final Device zzaRm;
    private final zzb zzaRn;
    private final String zzaRo;
    private final int[] zzaRp;
    private final String zzaRq;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzj();

    DataSource(int n, DataType dataType, String string, int n2, Device device, zzb zzb2, String string2, int[] nArray) {
        this.versionCode = n;
        this.zzaQI = dataType;
        this.type = n2;
        this.name = string;
        this.zzaRm = device;
        this.zzaRn = zzb2;
        this.zzaRo = string2;
        this.zzaRq = this.zzBu();
        this.zzaRp = nArray != null ? nArray : zzaRl;
    }

    private DataSource(Builder builder) {
        this.versionCode = 3;
        this.zzaQI = builder.zzaQI;
        this.type = builder.type;
        this.name = builder.name;
        this.zzaRm = builder.zzaRm;
        this.zzaRn = builder.zzaRn;
        this.zzaRo = builder.zzaRo;
        this.zzaRq = this.zzBu();
        this.zzaRp = null;
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzd.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzaQI;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAppPackageName() {
        return this.zzaRn == null ? null : this.zzaRn.getPackageName();
    }

    public zzb zzBs() {
        return this.zzaRn;
    }

    public Device getDevice() {
        return this.zzaRm;
    }

    public String getStreamName() {
        return this.zzaRo;
    }

    public int[] zzBt() {
        return this.zzaRp;
    }

    public String getStreamIdentifier() {
        return this.zzaRq;
    }

    private String zzBu() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzaQI.getName());
        if (this.zzaRn != null) {
            stringBuilder.append(":").append(this.zzaRn.getPackageName());
        }
        if (this.zzaRm != null) {
            stringBuilder.append(":").append(this.zzaRm.getStreamIdentifier());
        }
        if (this.zzaRo != null) {
            stringBuilder.append(":").append(this.zzaRo);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataSource && this.zza((DataSource)((Object)object));
    }

    private boolean zza(DataSource dataSource) {
        return this.zzaRq.equals(dataSource.zzaRq);
    }

    public int hashCode() {
        return this.zzaRq.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.name != null) {
            stringBuilder.append(":").append(this.name);
        }
        if (this.zzaRn != null) {
            stringBuilder.append(":").append((Object)this.zzaRn);
        }
        if (this.zzaRm != null) {
            stringBuilder.append(":").append((Object)this.zzaRm);
        }
        if (this.zzaRo != null) {
            stringBuilder.append(":").append(this.zzaRo);
        }
        stringBuilder.append(":").append((Object)this.zzaQI);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = String.valueOf(DataSource.zzgt(this.type));
        String string8 = String.valueOf(this.zzaQI.zzBv());
        if (this.zzaRn == null) {
            string6 = "";
        } else if (this.zzaRn.equals((Object)zzb.zzaQQ)) {
            string6 = ":gms";
        } else {
            String string9 = String.valueOf(this.zzaRn.getPackageName());
            string6 = string5 = string9.length() != 0 ? ":".concat(string9) : new String(":");
        }
        if (this.zzaRm != null) {
            string4 = String.valueOf(this.zzaRm.getModel());
            string3 = String.valueOf(this.zzaRm.getUid());
            string2 = new StringBuilder(2 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(":").append(string4).append(":").append(string3).toString();
        } else {
            string2 = string4 = "";
        }
        if (this.zzaRo != null) {
            String string10 = String.valueOf(this.zzaRo);
            string = string10.length() != 0 ? ":".concat(string10) : new String(":");
        } else {
            string = "";
        }
        string3 = string;
        return new StringBuilder(1 + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string7).append(":").append(string8).append(string5).append(string4).append(string3).toString();
    }

    private static String zzgt(int n) {
        switch (n) {
            case 0: {
                return "r";
            }
            case 1: {
                return "d";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "v";
            }
        }
        return "?";
    }

    public static String zzgu(int n) {
        switch (n) {
            case 1: {
                return "blood_pressure_esh2002";
            }
            case 2: {
                return "blood_pressure_esh2010";
            }
            case 3: {
                return "blood_pressure_aami";
            }
            case 4: {
                return "blood_pressure_bhs_a_a";
            }
            case 5: {
                return "blood_pressure_bhs_a_b";
            }
            case 6: {
                return "blood_pressure_bhs_b_a";
            }
            case 7: {
                return "blood_pressure_bhs_b_b";
            }
            case 8: {
                return "blood_glucose_iso151972003";
            }
            case 9: {
                return "blood_glucose_iso151972013";
            }
        }
        return "unknown";
    }

    private String getTypeString() {
        switch (this.type) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
            case 2: {
                return "cleaned";
            }
            case 3: {
                return "converted";
            }
        }
        return "derived";
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }

    public static final class Builder {
        private DataType zzaQI;
        private int type = -1;
        private String name;
        private Device zzaRm;
        private zzb zzaRn;
        private String zzaRo = "";

        public Builder setDataType(DataType dataType) {
            this.zzaQI = dataType;
            return this;
        }

        public Builder setType(int n) {
            this.type = n;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzaRm = device;
            return this;
        }

        public Builder setAppPackageName(String string) {
            this.zzaRn = zzb.zzdZ(string);
            return this;
        }

        public Builder setAppPackageName(Context context) {
            return this.setAppPackageName(context.getPackageName());
        }

        public Builder setStreamName(String string) {
            zzac.zzb((string != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzaRo = string;
            return this;
        }

        public DataSource build() {
            zzac.zza((this.zzaQI != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzac.zza((this.type >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

