/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzanz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zza {
    public static final int NO_LIMIT = 0;
    private final int mVersionCode;
    private final List<DataType> zzaQU;
    private final List<DataSource> zzaUV;
    private final long zzaed;
    private final long zzaQV;
    private final List<DataType> zzaVa;
    private final List<DataSource> zzaVb;
    private final int zzaQY;
    private final long zzaVc;
    private final DataSource zzaVd;
    private final int zzaVe;
    private final boolean zzaVf;
    private final boolean zzaVg;
    private final zzanz zzaVh;
    private final List<Device> zzaVi;
    private final List<Integer> zzaVj;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzi();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.mVersionCode = n;
        this.zzaQU = list;
        this.zzaUV = list2;
        this.zzaed = l;
        this.zzaQV = l2;
        this.zzaVa = list3;
        this.zzaVb = list4;
        this.zzaQY = n2;
        this.zzaVc = l3;
        this.zzaVd = dataSource;
        this.zzaVe = n3;
        this.zzaVf = bl;
        this.zzaVg = bl2;
        this.zzaVh = iBinder == null ? null : zzanz.zza.zzcq(iBinder);
        this.zzaVi = list5 == null ? Collections.emptyList() : list5;
        this.zzaVj = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzaQU, builder.zzaUV, builder.zzaed, builder.zzaQV, builder.zzaVa, builder.zzaVb, builder.zzaQY, builder.zzaVc, builder.zzaVd, builder.zzaVe, false, builder.zzaVg, null, builder.zzaVi, builder.zzaVj);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zzanz zzanz2) {
        this(dataReadRequest.zzaQU, dataReadRequest.zzaUV, dataReadRequest.zzaed, dataReadRequest.zzaQV, dataReadRequest.zzaVa, dataReadRequest.zzaVb, dataReadRequest.zzaQY, dataReadRequest.zzaVc, dataReadRequest.zzaVd, dataReadRequest.zzaVe, dataReadRequest.zzaVf, dataReadRequest.zzaVg, zzanz2, dataReadRequest.zzaVi, dataReadRequest.zzaVj);
    }

    public DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zzanz zzanz2, List<Device> list5, List<Integer> list6) {
        this(6, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzanz2 == null ? null : zzanz2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaed, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaQV, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzaQU;
    }

    public List<DataSource> getDataSources() {
        return this.zzaUV;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaVa;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaVb;
    }

    public int getBucketType() {
        return this.zzaQY;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaVc, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaVd;
    }

    public int getLimit() {
        return this.zzaVe;
    }

    public boolean zzCd() {
        return this.zzaVg;
    }

    public boolean zzCe() {
        return this.zzaVf;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadRequest && this.zzb((DataReadRequest)((Object)object));
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzaQU.equals(dataReadRequest.zzaQU) && this.zzaUV.equals(dataReadRequest.zzaUV) && this.zzaed == dataReadRequest.zzaed && this.zzaQV == dataReadRequest.zzaQV && this.zzaQY == dataReadRequest.zzaQY && this.zzaVb.equals(dataReadRequest.zzaVb) && this.zzaVa.equals(dataReadRequest.zzaVa) && zzaa.equal((Object)((Object)this.zzaVd), (Object)((Object)dataReadRequest.zzaVd)) && this.zzaVc == dataReadRequest.zzaVc && this.zzaVg == dataReadRequest.zzaVg && this.zzaVe == dataReadRequest.zzaVe && this.zzaVf == dataReadRequest.zzaVf && zzaa.equal((Object)this.zzaVh, (Object)dataReadRequest.zzaVh) && zzaa.equal(this.zzaVi, dataReadRequest.zzaVi) && zzaa.equal(this.zzaVj, dataReadRequest.zzaVj);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaQY, this.zzaed, this.zzaQV});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzaQU.isEmpty()) {
            for (DataType zza2 : this.zzaQU) {
                stringBuilder.append(zza2.zzBv()).append(" ");
            }
        }
        if (!this.zzaUV.isEmpty()) {
            for (DataSource dataSource : this.zzaUV) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzaQY != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzgn(this.zzaQY));
            if (this.zzaVc > 0L) {
                stringBuilder.append(" >").append(this.zzaVc).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaVa.isEmpty()) {
            for (DataType dataType : this.zzaVa) {
                stringBuilder.append(dataType.zzBv()).append(" ");
            }
        }
        if (!this.zzaVb.isEmpty()) {
            for (DataSource dataSource : this.zzaVb) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzaed, this.zzaed, this.zzaQV, this.zzaQV));
        if (this.zzaVd != null) {
            stringBuilder.append("activities: ").append(this.zzaVd.toDebugString());
        }
        if (!this.zzaVj.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzaVj.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzgu(n)).append(" ");
            }
        }
        if (this.zzaVg) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzzx() {
        return this.zzaQV;
    }

    public long zzpN() {
        return this.zzaed;
    }

    public long zzCf() {
        return this.zzaVc;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVh == null ? null : this.zzaVh.asBinder();
    }

    public List<Device> zzCg() {
        return this.zzaVi;
    }

    public List<Integer> zzCh() {
        return this.zzaVj;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public static class Builder {
        private List<DataType> zzaQU = new ArrayList<DataType>();
        private List<DataSource> zzaUV = new ArrayList<DataSource>();
        private List<DataType> zzaVa = new ArrayList<DataType>();
        private List<DataSource> zzaVb = new ArrayList<DataSource>();
        private DataSource zzaVd;
        private long zzaed;
        private long zzaQV;
        private int zzaQY = 0;
        private long zzaVc = 0L;
        private int zzaVe = 0;
        private boolean zzaVf = false;
        private boolean zzaVg = false;
        private final List<Device> zzaVi = new ArrayList<Device>();
        private final List<Integer> zzaVj = new ArrayList<Integer>();

        public Builder read(DataSource dataSource) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzac.zzb((!this.zzaVb.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaUV.contains((Object)dataSource)) {
                this.zzaUV.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzac.zza((!this.zzaVa.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzaQU.contains((Object)dataType)) {
                this.zzaQU.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzac.zza((!this.zzaUV.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzac.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzac.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzaVb.contains((Object)dataSource)) {
                this.zzaVb.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzac.zza((!this.zzaQU.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzac.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzac.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzaVa.contains((Object)dataType)) {
                this.zzaVa.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaQY == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaQY});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaQY = 1;
            this.zzaVc = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaQY == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaQY});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaQY = 3;
            this.zzaVc = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzac.zzb((this.zzaQY == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaQY});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzac.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaVd = dataSource;
            this.zzaQY = 3;
            this.zzaVc = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaQY == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaQY});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaQY = 4;
            this.zzaVc = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzac.zzb((this.zzaQY == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaQY});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzac.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaVd = dataSource;
            this.zzaQY = 4;
            this.zzaVc = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaQY == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaQY});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaQY = 2;
            this.zzaVc = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzaed = timeUnit.toMillis(l);
            this.zzaQV = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaVg = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzaVe = n;
            return this;
        }

        public DataReadRequest build() {
            zzac.zza((!this.zzaUV.isEmpty() || !this.zzaQU.isEmpty() || !this.zzaVb.isEmpty() || !this.zzaVa.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzac.zza((this.zzaed > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzaed});
            zzac.zza((this.zzaQV > 0L && this.zzaQV > this.zzaed ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaQV});
            boolean bl = this.zzaVb.isEmpty() && this.zzaVa.isEmpty();
            zzac.zza((bl && this.zzaQY == 0 || !bl && this.zzaQY != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

