/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzaob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
extends zza {
    private final int mVersionCode;
    private final String mName;
    private final List<Field> zzaVr;
    private final zzaob zzaVs;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzm();

    DataTypeCreateRequest(int n, String string, List<Field> list, IBinder iBinder) {
        this.mVersionCode = n;
        this.mName = string;
        this.zzaVr = Collections.unmodifiableList(list);
        this.zzaVs = zzaob.zza.zzcs(iBinder);
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.zzaVr, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest dataTypeCreateRequest, zzaob zzaob2) {
        this(dataTypeCreateRequest.mName, dataTypeCreateRequest.zzaVr, zzaob2);
    }

    public DataTypeCreateRequest(String string, List<Field> list, zzaob zzaob2) {
        this.mVersionCode = 3;
        this.mName = string;
        this.zzaVr = Collections.unmodifiableList(list);
        this.zzaVs = zzaob2;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.zzaVr;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVs == null ? null : this.zzaVs.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)((Object)object));
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzaa.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && zzaa.equal(this.zzaVr, dataTypeCreateRequest.zzaVr);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.mName, this.zzaVr});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("name", (Object)this.mName).zzg("fields", this.zzaVr).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public static class Builder {
        private String mName;
        private List<Field> zzaVr = new ArrayList<Field>();

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.zzaVr.contains((Object)field)) {
                this.zzaVr.add(field);
            }
            return this;
        }

        public Builder addField(String string, int n) {
            zzac.zzb((string != null && !string.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = Field.zzn(string, n);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzac.zza((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            zzac.zza((!this.zzaVr.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

