/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzs;
import com.google.android.gms.internal.zzaos;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zza {
    private final int mVersionCode;
    private final long zzaed;
    private final long zzaQV;
    private final DataSet zzaTM;
    private final zzaos zzaUS;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzs();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzaed = l;
        this.zzaQV = l2;
        this.zzaTM = dataSet;
        this.zzaUS = zzaos.zza.zzcJ(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzaed, builder.zzaQV, builder.zzaTM, null);
    }

    public DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.mVersionCode = 1;
        this.zzaed = l;
        this.zzaQV = l2;
        this.zzaTM = dataSet;
        this.zzaUS = zzaos.zza.zzcJ(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzpN(), dataUpdateRequest.zzzx(), dataUpdateRequest.getDataSet(), iBinder);
    }

    public long zzpN() {
        return this.zzaed;
    }

    public long zzzx() {
        return this.zzaQV;
    }

    public DataSet getDataSet() {
        return this.zzaTM;
    }

    public IBinder getCallbackBinder() {
        return this.zzaUS == null ? null : this.zzaUS.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaed, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaQV, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataUpdateRequest && this.zzb((DataUpdateRequest)((Object)object));
    }

    private boolean zzb(DataUpdateRequest dataUpdateRequest) {
        return this.zzaed == dataUpdateRequest.zzaed && this.zzaQV == dataUpdateRequest.zzaQV && zzaa.equal((Object)((Object)this.zzaTM), (Object)((Object)dataUpdateRequest.zzaTM));
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaed, this.zzaQV, this.zzaTM});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzaed).zzg("endTimeMillis", (Object)this.zzaQV).zzg("dataSet", (Object)this.zzaTM).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzs.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzaed;
        private long zzaQV;
        private DataSet zzaTM;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzac.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzaed = timeUnit.toMillis(l);
            this.zzaQV = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzac.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzaTM = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            this.zzCk();
            return new DataUpdateRequest(this);
        }

        private void zzCk() {
            zzac.zza((long)this.zzaed, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzac.zza((long)this.zzaQV, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzac.zzb((Object)((Object)this.zzaTM), (Object)"Must set the data set");
            for (DataPoint dataPoint : this.zzaTM.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                boolean bl = l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < this.zzaed || l2 != 0L && l2 > this.zzaQV || l > this.zzaQV || l < this.zzaed;
                zzac.zza((!bl ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, this.zzaed, this.zzaQV});
            }
        }
    }
}

