/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzaRJ;
    private final DataType zzaRK;
    private final long zzaTN;
    private final long zzaVR;
    private final long zzaVQ;
    private final int zzaTO;
    private final LocationRequest zzaVV;
    private final long zzaVW;

    private SensorRequest(Builder builder) {
        this.zzaRJ = builder.zzaRJ;
        this.zzaRK = builder.zzaRK;
        this.zzaTN = builder.zzaTN;
        this.zzaVR = builder.zzaVR;
        this.zzaVQ = builder.zzaVQ;
        this.zzaTO = builder.zzaTO;
        this.zzaVV = null;
        this.zzaVW = builder.zzaVW;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzaVV = locationRequest;
        this.zzaTN = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzaVR = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzaVQ = this.zzaTN;
        this.zzaRK = dataSource.getDataType();
        this.zzaTO = SensorRequest.zza(locationRequest);
        this.zzaRJ = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzaVW = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzaRJ;
    }

    public DataType getDataType() {
        return this.zzaRK;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTN, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaVR, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaVQ, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzaTO;
    }

    public long zzCu() {
        return this.zzaVW;
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("dataSource", (Object)this.zzaRJ).zzg("dataType", (Object)this.zzaRK).zzg("samplingRateMicros", (Object)this.zzaTN).zzg("deliveryLatencyMicros", (Object)this.zzaVQ).zzg("timeOutMicros", (Object)this.zzaVW).toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SensorRequest && this.zza((SensorRequest)object);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzaa.equal((Object)((Object)this.zzaRJ), (Object)((Object)sensorRequest.zzaRJ)) && zzaa.equal((Object)((Object)this.zzaRK), (Object)((Object)sensorRequest.zzaRK)) && this.zzaTN == sensorRequest.zzaTN && this.zzaVR == sensorRequest.zzaVR && this.zzaVQ == sensorRequest.zzaVQ && this.zzaTO == sensorRequest.zzaTO && zzaa.equal((Object)this.zzaVV, (Object)sensorRequest.zzaVV) && this.zzaVW == sensorRequest.zzaVW;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaRJ, this.zzaRK, this.zzaTN, this.zzaVR, this.zzaVQ, this.zzaTO, this.zzaVV, this.zzaVW});
    }

    public static class Builder {
        private DataSource zzaRJ;
        private DataType zzaRK;
        private long zzaTN = -1L;
        private long zzaVR = 0L;
        private long zzaVQ = 0L;
        private boolean zzaVX = false;
        private int zzaTO = 2;
        private long zzaVW = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzaRJ = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzaRK = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzac.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzaTN = timeUnit.toMicros(l);
            if (!this.zzaVX) {
                this.zzaVR = this.zzaTN / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzaVX = true;
            this.zzaVR = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzaVQ = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            this.zzaTO = zzank.zzgT(n);
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzac.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaVW = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzac.zza((this.zzaRJ != null || this.zzaRK != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzac.zza((this.zzaRK == null || this.zzaRJ == null || this.zzaRK.equals((Object)this.zzaRJ.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

