/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzba;
import com.google.android.gms.internal.zzaoq;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zza {
    private final int mVersionCode;
    private final String zzaWc;
    private final String zzVW;
    private final long zzaed;
    private final long zzaQV;
    private final List<DataType> zzaQU;
    private final List<DataSource> zzaUV;
    private boolean zzaWd;
    private final boolean zzaVg;
    private final List<String> zzaWe;
    private final zzaoq zzaWf;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzba();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzaWc = string;
        this.zzVW = string2;
        this.zzaed = l;
        this.zzaQV = l2;
        this.zzaQU = list;
        this.zzaUV = list2;
        this.zzaWd = bl;
        this.zzaVg = bl2;
        this.zzaWe = list3;
        this.zzaWf = zzaoq.zza.zzcH(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzaWc, builder.zzVW, builder.zzaed, builder.zzaQV, builder.zzaQU, builder.zzaUV, builder.zzaWd, builder.zzaVg, builder.zzaWe, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzaoq zzaoq2) {
        this(sessionReadRequest.zzaWc, sessionReadRequest.zzVW, sessionReadRequest.zzaed, sessionReadRequest.zzaQV, sessionReadRequest.zzaQU, sessionReadRequest.zzaUV, sessionReadRequest.zzaWd, sessionReadRequest.zzaVg, sessionReadRequest.zzaWe, zzaoq2);
    }

    public SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzaoq zzaoq2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzaoq2 == null ? null : zzaoq2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaed, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaQV, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzaWc;
    }

    public String getSessionId() {
        return this.zzVW;
    }

    public List<DataType> getDataTypes() {
        return this.zzaQU;
    }

    public List<DataSource> getDataSources() {
        return this.zzaUV;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzaWd;
    }

    public List<String> getExcludedPackages() {
        return this.zzaWe;
    }

    public boolean zzCd() {
        return this.zzaVg;
    }

    public long zzzx() {
        return this.zzaQV;
    }

    public long zzpN() {
        return this.zzaed;
    }

    public boolean zzCw() {
        return this.zzaWd;
    }

    public IBinder getCallbackBinder() {
        return this.zzaWf == null ? null : this.zzaWf.asBinder();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SessionReadRequest && this.zzb((SessionReadRequest)((Object)object));
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzaa.equal((Object)this.zzaWc, (Object)sessionReadRequest.zzaWc) && this.zzVW.equals(sessionReadRequest.zzVW) && this.zzaed == sessionReadRequest.zzaed && this.zzaQV == sessionReadRequest.zzaQV && zzaa.equal(this.zzaQU, sessionReadRequest.zzaQU) && zzaa.equal(this.zzaUV, sessionReadRequest.zzaUV) && this.zzaWd == sessionReadRequest.zzaWd && this.zzaWe.equals(sessionReadRequest.zzaWe) && this.zzaVg == sessionReadRequest.zzaVg;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaWc, this.zzVW, this.zzaed, this.zzaQV});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("sessionName", (Object)this.zzaWc).zzg("sessionId", (Object)this.zzVW).zzg("startTimeMillis", (Object)this.zzaed).zzg("endTimeMillis", (Object)this.zzaQV).zzg("dataTypes", this.zzaQU).zzg("dataSources", this.zzaUV).zzg("sessionsFromAllApps", (Object)this.zzaWd).zzg("excludedPackages", this.zzaWe).zzg("useServer", (Object)this.zzaVg).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzba.zza(this, parcel, n);
    }

    public static class Builder {
        private String zzaWc;
        private String zzVW;
        private long zzaed = 0L;
        private long zzaQV = 0L;
        private List<DataType> zzaQU = new ArrayList<DataType>();
        private List<DataSource> zzaUV = new ArrayList<DataSource>();
        private boolean zzaWd = false;
        private boolean zzaVg = false;
        private List<String> zzaWe = new ArrayList<String>();

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzaed = timeUnit.toMillis(l);
            this.zzaQV = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzaWc = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.zzVW = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzaUV.contains((Object)dataSource)) {
                this.zzaUV.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaQU.contains((Object)dataType)) {
                this.zzaQU.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzaWd = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzac.zzb((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzaWe.contains(string)) {
                this.zzaWe.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaVg = true;
            return this;
        }

        public SessionReadRequest build() {
            zzac.zzb((this.zzaed > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzaed});
            zzac.zzb((this.zzaQV > 0L && this.zzaQV > this.zzaed ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaQV});
            return new SessionReadRequest(this);
        }
    }
}

