/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.fitness.request.zzg;
import com.google.android.gms.fitness.request.zzq;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzzv;

public class zzaoz
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient googleApiClient, DataSet dataSet) {
        return this.zza(googleApiClient, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzac.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
        zzac.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzac.zzb((Object)((Object)dataSet.getDataSource().zzBs()), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza((zzzv.zza)new zzant.zzc(this, googleApiClient){

            protected void zza(zzant zzant2) throws RemoteException {
                zzape zzape2 = new zzape((zzzv.zzb<Status>)this);
                ((zzaoi)zzant2.zzwW()).zza(new zzg(dataSet, zzape2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient googleApiClient, final DataDeleteRequest dataDeleteRequest) {
        return googleApiClient.zza((zzzv.zza)new zzant.zzc(this, googleApiClient){

            protected void zza(zzant zzant2) throws RemoteException {
                zzape zzape2 = new zzape((zzzv.zzb<Status>)this);
                ((zzaoi)zzant2.zzwW()).zza(new DataDeleteRequest(dataDeleteRequest, zzape2));
            }
        });
    }

    @Override
    public PendingResult<Status> updateData(GoogleApiClient googleApiClient, final DataUpdateRequest dataUpdateRequest) {
        zzac.zzb((Object)((Object)dataUpdateRequest.getDataSet()), (Object)"Must set the data set");
        zzac.zza((long)dataUpdateRequest.zzpN(), (Object)"Must set a non-zero value for startTimeMillis/startTime");
        zzac.zza((long)dataUpdateRequest.zzzx(), (Object)"Must set a non-zero value for endTimeMillis/endTime");
        return googleApiClient.zza((zzzv.zza)new zzant.zzc(this, googleApiClient){

            protected void zza(zzant zzant2) throws RemoteException {
                zzape zzape2 = new zzape((zzzv.zzb<Status>)this);
                ((zzaoi)zzant2.zzwW()).zza(new DataUpdateRequest(dataUpdateRequest, (IBinder)zzape2));
            }
        });
    }

    @Override
    public PendingResult<Status> registerDataUpdateListener(GoogleApiClient googleApiClient, final DataUpdateListenerRegistrationRequest dataUpdateListenerRegistrationRequest) {
        return googleApiClient.zza((zzzv.zza)new zzant.zzc(this, googleApiClient){

            protected void zza(zzant zzant2) throws RemoteException {
                zzape zzape2 = new zzape((zzzv.zzb<Status>)this);
                ((zzaoi)zzant2.zzwW()).zza(new DataUpdateListenerRegistrationRequest(dataUpdateListenerRegistrationRequest, (IBinder)zzape2));
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterDataUpdateListener(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        return googleApiClient.zzb((zzzv.zza)new zzant.zzc(this, googleApiClient){

            protected void zza(zzant zzant2) throws RemoteException {
                zzape zzape2 = new zzape((zzzv.zzb<Status>)this);
                ((zzaoi)zzant2.zzwW()).zza(new zzq(pendingIntent, (IBinder)zzape2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient googleApiClient, final DataReadRequest dataReadRequest) {
        return googleApiClient.zza((zzzv.zza)new zzant.zza<DataReadResult>(this, googleApiClient){

            protected void zza(zzant zzant2) throws RemoteException {
                zza zza2 = new zza((zzzv.zzb)this);
                ((zzaoi)zzant2.zzwW()).zza(new DataReadRequest(dataReadRequest, zza2));
            }

            protected DataReadResult zzW(Status status) {
                return DataReadResult.zza(status, dataReadRequest.getDataTypes(), dataReadRequest.getDataSources());
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzW(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient googleApiClient, DataType dataType) {
        return this.zza(googleApiClient, dataType, false);
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotalFromLocalDevice(GoogleApiClient googleApiClient, DataType dataType) {
        return this.zza(googleApiClient, dataType, true);
    }

    private PendingResult<DailyTotalResult> zza(GoogleApiClient googleApiClient, final DataType dataType, final boolean bl) {
        return googleApiClient.zza((zzzv.zza)new zzant.zza<DailyTotalResult>(this, googleApiClient){

            protected void zza(zzant zzant2) throws RemoteException {
                zzany.zza zza2 = new zzany.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zzb(dailyTotalResult);
                    }
                };
                zzd zzd2 = new zzd(zza2, dataType, bl);
                ((zzaoi)zzant2.zzwW()).zza(zzd2);
            }

            protected DailyTotalResult zzX(Status status) {
                return DailyTotalResult.zza(status, dataType);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzX(status);
            }
        });
    }

    private static class zza
    extends zzanz.zza {
        private final zzzv.zzb<DataReadResult> zzaFq;
        private int zzaUu = 0;
        private DataReadResult zzaUv = null;

        private zza(zzzv.zzb<DataReadResult> zzb2) {
            this.zzaFq = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                if (Log.isLoggable((String)"Fitness", (int)2)) {
                    int n = this.zzaUu;
                    Log.v((String)"Fitness", (String)new StringBuilder(33).append("Received batch result ").append(n).toString());
                }
                if (this.zzaUv == null) {
                    this.zzaUv = dataReadResult;
                } else {
                    this.zzaUv.zzb(dataReadResult);
                }
                ++this.zzaUu;
                if (this.zzaUu == this.zzaUv.zzCC()) {
                    this.zzaFq.setResult((Object)this.zzaUv);
                }
            }
        }
    }
}

