/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzapf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zza {
    private final int zzaiI;
    private final long zzafe;
    private final long zzaSt;
    private final List<DataSource> zzaVw;
    private final List<DataType> zzaSs;
    private final List<Session> zzaVx;
    private final boolean zzaVy;
    private final boolean zzaVz;
    private final zzapf zzaVt;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzf();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.zzaiI = n;
        this.zzafe = l;
        this.zzaSt = l2;
        this.zzaVw = Collections.unmodifiableList(list);
        this.zzaSs = Collections.unmodifiableList(list2);
        this.zzaVx = list3;
        this.zzaVy = bl;
        this.zzaVz = bl2;
        this.zzaVt = zzapf.zza.zzcJ(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzafe, builder.zzaSt, builder.zzaVw, builder.zzaSs, builder.zzaVx, builder.zzaVy, builder.zzaVz, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzapf zzapf2) {
        this(dataDeleteRequest.zzafe, dataDeleteRequest.zzaSt, dataDeleteRequest.zzaVw, dataDeleteRequest.zzaSs, dataDeleteRequest.zzaVx, dataDeleteRequest.zzaVy, dataDeleteRequest.zzaVz, zzapf2);
    }

    public DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzapf zzapf2) {
        this.zzaiI = 3;
        this.zzafe = l;
        this.zzaSt = l2;
        this.zzaVw = Collections.unmodifiableList(list);
        this.zzaSs = Collections.unmodifiableList(list2);
        this.zzaVx = list3;
        this.zzaVy = bl;
        this.zzaVz = bl2;
        this.zzaVt = zzapf2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafe, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSt, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaVw;
    }

    public List<DataType> getDataTypes() {
        return this.zzaSs;
    }

    public List<Session> getSessions() {
        return this.zzaVx;
    }

    public boolean deleteAllData() {
        return this.zzaVy;
    }

    public boolean deleteAllSessions() {
        return this.zzaVz;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)((Object)object));
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzafe == dataDeleteRequest.zzafe && this.zzaSt == dataDeleteRequest.zzaSt && zzaa.equal(this.zzaVw, dataDeleteRequest.zzaVw) && zzaa.equal(this.zzaSs, dataDeleteRequest.zzaSs) && zzaa.equal(this.zzaVx, dataDeleteRequest.zzaVx) && this.zzaVy == dataDeleteRequest.zzaVy && this.zzaVz == dataDeleteRequest.zzaVz;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzafe, this.zzaSt});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzafe).zzg("endTimeMillis", (Object)this.zzaSt).zzg("dataSources", this.zzaVw).zzg("dateTypes", this.zzaSs).zzg("sessions", this.zzaVx).zzg("deleteAllData", (Object)this.zzaVy).zzg("deleteAllSessions", (Object)this.zzaVz).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public boolean zzCO() {
        return this.zzaVy;
    }

    public boolean zzCP() {
        return this.zzaVz;
    }

    public long zzAm() {
        return this.zzaSt;
    }

    public long zzqn() {
        return this.zzafe;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVt == null ? null : this.zzaVt.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzafe;
        private long zzaSt;
        private List<DataSource> zzaVw = new ArrayList<DataSource>();
        private List<DataType> zzaSs = new ArrayList<DataType>();
        private List<Session> zzaVx = new ArrayList<Session>();
        private boolean zzaVy = false;
        private boolean zzaVz = false;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzac.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzafe = timeUnit.toMillis(l);
            this.zzaSt = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzac.zzb((boolean)this.zzaSs.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzac.zzb((boolean)this.zzaVw.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzaVy = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzac.zzb((!this.zzaVy ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzac.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzaSs.contains((Object)dataType)) {
                this.zzaSs.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzac.zzb((!this.zzaVy ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaVw.contains((Object)dataSource)) {
                this.zzaVw.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzac.zzb((!this.zzaVz ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzac.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzac.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaVx.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzac.zzb((boolean)this.zzaVx.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzaVz = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzac.zza((this.zzafe > 0L && this.zzaSt > this.zzafe ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaVy || !this.zzaVw.isEmpty() || !this.zzaSs.isEmpty();
            boolean bl2 = this.zzaVz || !this.zzaVx.isEmpty();
            zzac.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzCQ();
            return new DataDeleteRequest(this);
        }

        private void zzCQ() {
            if (this.zzaVx.isEmpty()) {
                return;
            }
            for (Session session : this.zzaVx) {
                zzac.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzafe && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzaSt ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzafe, this.zzaSt});
            }
        }
    }
}

