/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzai;
import com.google.android.gms.fitness.request.zzbj;
import com.google.android.gms.internal.zzapf;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
extends zza {
    private final int zzaiI;
    private final List<DataType> zzaSs;
    private final zzai zzaWJ;
    private final int zzaWK;
    private final zzapf zzaVt;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzbj();

    StartBleScanRequest(int n, List<DataType> list, IBinder iBinder, int n2, IBinder iBinder2) {
        this.zzaiI = n;
        this.zzaSs = list;
        this.zzaWJ = zzai.zza.zzcN(iBinder);
        this.zzaWK = n2;
        this.zzaVt = zzapf.zza.zzcJ(iBinder2);
    }

    private StartBleScanRequest(Builder builder) {
        this(zzb.zzb((Object[])builder.zzaVQ), builder.zzaWJ, builder.zzaWK, null);
    }

    public StartBleScanRequest(StartBleScanRequest startBleScanRequest, zzapf zzapf2) {
        this(startBleScanRequest.zzaSs, startBleScanRequest.zzaWJ, startBleScanRequest.zzaWK, zzapf2);
    }

    public StartBleScanRequest(List<DataType> list, zzai zzai2, int n, zzapf zzapf2) {
        this.zzaiI = 4;
        this.zzaSs = list;
        this.zzaWJ = zzai2;
        this.zzaWK = n;
        this.zzaVt = zzapf2;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzaSs);
    }

    public int getTimeoutSecs() {
        return this.zzaWK;
    }

    public IBinder zzDm() {
        return this.zzaWJ.asBinder();
    }

    public IBinder getCallbackBinder() {
        return this.zzaVt == null ? null : this.zzaVt.asBinder();
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("dataTypes", this.zzaSs).zzg("timeoutSecs", (Object)this.zzaWK).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzbj.zza(this, parcel, n);
    }

    public static class Builder {
        private DataType[] zzaVQ = new DataType[0];
        private zzai zzaWJ;
        private int zzaWK = 10;

        public Builder setDataTypes(DataType ... dataTypeArray) {
            this.zzaVQ = dataTypeArray;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzCL().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzai zzai2) {
            this.zzaWJ = zzai2;
            return this;
        }

        public Builder setTimeoutSecs(int n) {
            zzac.zzb((n > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzac.zzb((n <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzaWK = n;
            return this;
        }

        public StartBleScanRequest build() {
            zzac.zza((this.zzaWJ != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

