/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.fitness.zza;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzakw;
    private final long zzahb;
    private final long zzaTs;
    private final Session zzaTi;
    private final int zzaTt;
    private final List<DataSet> zzaTu;
    private final int zzaTv;
    private boolean zzaTw = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.zzakw = n;
        this.zzahb = l;
        this.zzaTs = l2;
        this.zzaTi = session;
        this.zzaTt = n2;
        this.zzaTu = list;
        this.zzaTv = n3;
        this.zzaTw = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.zzahb, rawBucket.zzaTs, rawBucket.zzaTi, rawBucket.zzaUZ, Bucket.zza(rawBucket.zzaTu, list), rawBucket.zzaTv, rawBucket.zzaTw);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzahb, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTs, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzaTi;
    }

    public String getActivity() {
        return zza.getName(this.zzaTt);
    }

    public final int zztC() {
        return this.zzaTt;
    }

    public List<DataSet> getDataSets() {
        return this.zzaTu;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaTu) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzaTv;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Bucket)) break block3;
                Bucket bucket = (Bucket)((Object)object);
                Bucket bucket2 = this;
                if (!(bucket2.zzahb == bucket.zzahb && bucket2.zzaTs == bucket.zzaTs && bucket2.zzaTt == bucket.zzaTt && zzbh.equal(bucket2.zzaTu, bucket.zzaTu) && bucket2.zzaTv == bucket.zzaTv && bucket2.zzaTw == bucket.zzaTw)) break block3;
            }
            return true;
        }
        return false;
    }

    public final boolean zza(Bucket bucket) {
        return this.zzahb == bucket.zzahb && this.zzaTs == bucket.zzaTs && this.zzaTt == bucket.zzaTt && this.zzaTv == bucket.zzaTv;
    }

    public final boolean zztD() {
        if (this.zzaTw) {
            return true;
        }
        Iterator<DataSet> iterator = this.zzaTu.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zztD()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzahb, this.zzaTs, this.zzaTt, this.zzaTv});
    }

    public String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("startTime", (Object)this.zzahb).zzg("endTime", (Object)this.zzaTs).zzg("activity", (Object)this.zzaTt).zzg("dataSets", this.zzaTu).zzg("bucketType", (Object)Bucket.zzaS(this.zzaTv)).zzg("serverHasMoreData", (Object)this.zzaTw).toString();
    }

    public static String zzaS(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Bucket bucket = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)bucket.zzahb);
        zzd.zza((Parcel)parcel2, (int)2, (long)bucket.zzaTs);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)bucket.getSession(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, (int)bucket.zzaTt);
        zzd.zzc((Parcel)parcel2, (int)5, bucket.getDataSets(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, (int)bucket.getBucketType());
        zzd.zza((Parcel)parcel2, (int)7, (boolean)bucket.zztD());
        zzd.zzc((Parcel)parcel2, (int)1000, (int)bucket.zzakw);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

