/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzbvv;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzaTe;
    private final DataType zzaTd;
    private final List<DataPoint> zzaTF;
    private final List<DataSource> zzaTG;
    private boolean zzaTH = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.zzaTe = dataSource;
        this.zzaTd = dataSource.getDataType();
        this.zzaTH = bl;
        this.zzaTF = new ArrayList<DataPoint>(list.size());
        this.zzaTG = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzaTF.add(new DataPoint(this.zzaTG, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.zzaTe = (DataSource)((Object)zzbr.zzu((Object)((Object)dataSource)));
        this.zzaTd = dataSource.getDataType();
        this.zzaTF = new ArrayList<DataPoint>();
        this.zzaTG = new ArrayList<DataSource>();
        this.zzaTG.add(this.zzaTe);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        int n = rawDataSet.zzaVd;
        List<DataSource> list2 = list;
        this.zzaTe = n >= 0 && n < list2.size() ? list2.get(n) : null;
        this.zzaTd = this.zzaTe.getDataType();
        this.zzaTG = list;
        this.zzaTH = rawDataSet.zzaTw;
        List<RawDataPoint> list3 = rawDataSet.zzaVi;
        this.zzaTF = new ArrayList<DataPoint>(list3.size());
        for (RawDataPoint rawDataPoint : list3) {
            this.zzaTF.add(new DataPoint(this.zzaTG, rawDataPoint));
        }
    }

    public static DataSet create(DataSource dataSource) {
        zzbr.zzb((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public final DataPoint createDataPoint() {
        return DataPoint.create(this.zzaTe);
    }

    public final void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzbr.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzaTe.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzaTe});
        dataPoint.zztJ();
        DataSet.zzb(dataPoint);
        this.zza(dataPoint);
    }

    private final void zza(DataPoint dataPoint) {
        this.zzaTF.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzaTG.contains((Object)dataSource)) {
            this.zzaTG.add(dataSource);
        }
    }

    public final void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public final void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zza(dataPoint);
        }
    }

    public final DataSource getDataSource() {
        return this.zzaTe;
    }

    public final DataType getDataType() {
        return this.zzaTe.getDataType();
    }

    public final List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzaTF);
    }

    public final boolean isEmpty() {
        return this.zzaTF.isEmpty();
    }

    public final boolean zztD() {
        return this.zzaTH;
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataSet)) break block3;
                DataSet dataSet = (DataSet)((Object)object);
                DataSet dataSet2 = this;
                if (!(zzbh.equal((Object)((Object)dataSet2.getDataType()), (Object)((Object)dataSet.getDataType())) && zzbh.equal((Object)((Object)dataSet2.zzaTe), (Object)((Object)dataSet.zzaTe)) && zzbh.equal(dataSet2.zzaTF, dataSet.zzaTF) && dataSet2.zzaTH == dataSet.zzaTH)) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaTe});
    }

    public final String toString() {
        List<RawDataPoint> list = this.zztK();
        return String.format("DataSet{%s %s}", this.zzaTe.toDebugString(), this.zzaTF.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzaTF.size(), list.subList(0, 5)));
    }

    public static void zzb(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzbvv.zza(dataPoint, zzf.zzaTx);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    private List<RawDataPoint> zztK() {
        return this.zzA(this.zzaTG);
    }

    final List<RawDataPoint> zzA(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzaTF.size());
        for (DataPoint dataPoint : this.zzaTF) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSet dataSet = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)dataSet.getDataSource(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)dataSet.getDataType(), (int)n, (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, dataSet.zztK(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, dataSet.zzaTG, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (boolean)dataSet.zzaTH);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataSet.versionCode);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

