/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.zzo;
import com.google.android.gms.internal.zzbvu;
import com.google.android.gms.internal.zzcaz;
import java.util.Arrays;

public final class Device
extends zza {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final int versionCode;
    private final String zzaUj;
    private final String zzaUk;
    private final String version;
    private final String zzaUl;
    private final int type;
    private final int zzaUm;
    public static final Parcelable.Creator<Device> CREATOR = new zzo();

    public static Device getLocalDevice(Context context) {
        int n = zzbvu.zzaU(context);
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    private Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(1, string, string2, "", string4, n, n2);
    }

    Device(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        this.versionCode = n;
        this.zzaUj = (String)zzbr.zzu((Object)string);
        this.zzaUk = (String)zzbr.zzu((Object)string2);
        this.version = "";
        String string5 = string4;
        if (string5 == null) {
            throw new IllegalStateException("Device UID is null.");
        }
        this.zzaUl = string5;
        this.type = n2;
        this.zzaUm = n3;
    }

    public final String getManufacturer() {
        return this.zzaUj;
    }

    public final String getModel() {
        return this.zzaUk;
    }

    public final String getUid() {
        return this.zzaUl;
    }

    public final int getType() {
        return this.type;
    }

    final String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzaUj, this.zzaUk, this.zzaUl);
    }

    public final String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.version, this.type, this.zzaUm);
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Device)) break block3;
                Device device = (Device)((Object)object);
                Device device2 = this;
                if (!(zzbh.equal((Object)device2.zzaUj, (Object)device.zzaUj) && zzbh.equal((Object)device2.zzaUk, (Object)device.zzaUk) && zzbh.equal((Object)device2.version, (Object)device.version) && zzbh.equal((Object)device2.zzaUl, (Object)device.zzaUl) && device2.type == device.type && device2.zzaUm == device.zzaUm)) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaUj, this.zzaUk, this.version, this.zzaUl, this.type});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Device device = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)device.getManufacturer(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)device.getModel(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)device.version, (boolean)false);
        Device device2 = device;
        zzd.zza((Parcel)parcel2, (int)4, (String)(device2.zzaUm == 1 ? device2.zzaUl : zzcaz.zzdi(device2.zzaUl)), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)device.getType());
        zzd.zzc((Parcel)parcel2, (int)6, (int)device.zzaUm);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)device.versionCode);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

