/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.zzac;
import com.google.android.gms.fitness.data.zzad;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.zza;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Session
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzakw;
    private final long zzahb;
    private final long zzaTs;
    private final String mName;
    private final String zzaVj;
    private final String zzafc;
    private final int zzaTt;
    private final zzb zzaVk;
    private final Long zzaVl;
    public static final Parcelable.Creator<Session> CREATOR = new zzad();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, zzb zzb2, Long l3) {
        this.zzakw = n;
        this.zzahb = l;
        this.zzaTs = l2;
        this.mName = string;
        this.zzaVj = string2;
        this.zzafc = string3;
        this.zzaTt = n2;
        this.zzaVk = zzb2;
        this.zzaVl = l3;
    }

    private Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, Long l3) {
        this(3, l, l2, string, string2, string3, n, null, l3);
    }

    private Session(Builder builder) {
        this(builder.zzahb, builder.zzaTs, builder.mName, builder.zzaVj, builder.zzafc, builder.zzaTt, null, builder.zzaVl);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zze.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzahb, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTs, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzbr.zza((this.zzaVl != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzaVl, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzaVl != null;
    }

    public boolean isOngoing() {
        return this.zzaTs == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaVj;
    }

    public String getDescription() {
        return this.zzafc;
    }

    public String getActivity() {
        return zza.getName(this.zzaTt);
    }

    public String getAppPackageName() {
        if (this.zzaVk == null) {
            return null;
        }
        return this.zzaVk.getPackageName();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Session)) break block3;
                Session session = (Session)((Object)object);
                Session session2 = this;
                if (!(session2.zzahb == session.zzahb && session2.zzaTs == session.zzaTs && zzbh.equal((Object)session2.mName, (Object)session.mName) && zzbh.equal((Object)session2.zzaVj, (Object)session.zzaVj) && zzbh.equal((Object)session2.zzafc, (Object)session.zzafc) && zzbh.equal((Object)((Object)session2.zzaVk), (Object)((Object)session.zzaVk)) && session2.zzaTt == session.zzaTt)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzahb, this.zzaTs, this.zzaVj});
    }

    public String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("startTime", (Object)this.zzahb).zzg("endTime", (Object)this.zzaTs).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaVj).zzg("description", (Object)this.zzafc).zzg("activity", (Object)this.zzaTt).zzg("application", (Object)this.zzaVk).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Session session = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)session.zzahb);
        zzd.zza((Parcel)parcel2, (int)2, (long)session.zzaTs);
        zzd.zza((Parcel)parcel2, (int)3, (String)session.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)session.getIdentifier(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)session.getDescription(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)session.zzaTt);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)session.zzakw);
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)session.zzaVk, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (Long)session.zzaVl, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ Session(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private long zzahb = 0L;
        private long zzaTs = 0L;
        private String mName = null;
        private String zzaVj;
        private String zzafc;
        private int zzaTt = 4;
        private Long zzaVl;

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzbr.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzahb = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzbr.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzaTs = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzbr.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzbr.zzaf((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzaVj = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzbr.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzafc = string;
            return this;
        }

        public Builder setActivity(String string) {
            int n = zza.zzcX(string);
            Builder builder = this;
            this.zzaTt = n;
            return builder;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzaVl = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzbr.zza((this.zzahb > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzbr.zza((this.zzaTs == 0L || this.zzaTs > this.zzahb ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaVj == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.zzahb;
                this.zzaVj = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.zzafc == null) {
                this.zzafc = "";
            }
            return new Session(this, null);
        }
    }
}

