/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzai;
import com.google.android.gms.fitness.zza;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends com.google.android.gms.common.internal.safeparcel.zza {
    private final int versionCode;
    private final int format;
    private boolean zzaVp;
    private float value;
    private String zzaIH;
    private Map<String, MapValue> zzaVq;
    private int[] zzaVr;
    private float[] zzaVs;
    private byte[] zzaVt;
    public static final Parcelable.Creator<Value> CREATOR = new zzai();

    public Value(int n) {
        this(3, n, false, 0.0f, null, null, null, null, null);
    }

    Value(int n, int n2, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        ArrayMap arrayMap;
        this.versionCode = n;
        this.format = n2;
        this.zzaVp = bl;
        this.value = f;
        this.zzaIH = string;
        Bundle bundle2 = bundle;
        if (bundle2 == null) {
            arrayMap = null;
        } else {
            bundle2.setClassLoader(MapValue.class.getClassLoader());
            ArrayMap arrayMap2 = new ArrayMap(bundle2.size());
            for (String string2 : bundle2.keySet()) {
                arrayMap2.put(string2, (MapValue)bundle2.getParcelable(string2));
            }
            arrayMap = arrayMap2;
        }
        this.zzaVq = arrayMap;
        this.zzaVr = nArray;
        this.zzaVs = fArray;
        this.zzaVt = byArray;
    }

    public final void setInt(int n) {
        zzbr.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzaVp = true;
        this.value = Float.intBitsToFloat(n);
    }

    public final void setFloat(float f) {
        zzbr.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzaVp = true;
        this.value = f;
    }

    public final void setString(String string) {
        zzbr.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzaVp = true;
        this.zzaIH = string;
    }

    public final void setKeyValue(String string, float f) {
        zzbr.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzaVp = true;
        if (this.zzaVq == null) {
            this.zzaVq = new HashMap<String, MapValue>();
        }
        this.zzaVq.put(string, new MapValue(2, f));
    }

    public final void clearKey(String string) {
        zzbr.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzaVq != null) {
            this.zzaVq.remove(string);
        }
    }

    public final void setActivity(String string) {
        this.setInt(zza.zzcX(string));
    }

    public final boolean isSet() {
        return this.zzaVp;
    }

    public final int getFormat() {
        return this.format;
    }

    public final int asInt() {
        zzbr.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.value);
    }

    public final float asFloat() {
        zzbr.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.value;
    }

    public final String asString() {
        zzbr.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzaIH;
    }

    @Nullable
    public final Float getKeyValue(String string) {
        zzbr.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzaVq != null && this.zzaVq.containsKey(string)) {
            return Float.valueOf(this.zzaVq.get(string).asFloat());
        }
        return null;
    }

    public final String asActivity() {
        return zza.getName(this.asInt());
    }

    public final boolean equals(Object object) {
        block18: {
            block17: {
                boolean bl;
                if (this == object) break block17;
                if (!(object instanceof Value)) break block18;
                Value value = (Value)((Object)object);
                Value value2 = this;
                if (value2.format == value.format && value2.zzaVp == value.zzaVp) {
                    switch (value2.format) {
                        case 1: {
                            if (value2.asInt() == value.asInt()) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 2: {
                            if (value2.value == value.value) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 3: {
                            bl = zzbh.equal((Object)value2.zzaIH, (Object)value.zzaIH);
                            break;
                        }
                        case 4: {
                            bl = zzbh.equal(value2.zzaVq, value.zzaVq);
                            break;
                        }
                        case 5: {
                            bl = Arrays.equals(value2.zzaVr, value.zzaVr);
                            break;
                        }
                        case 6: {
                            bl = Arrays.equals(value2.zzaVs, value.zzaVs);
                            break;
                        }
                        case 7: {
                            bl = Arrays.equals(value2.zzaVt, value.zzaVt);
                            break;
                        }
                        default: {
                            if (value2.value == value.value) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                    }
                } else {
                    bl = false;
                }
                if (!bl) break block18;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.value), this.zzaIH, this.zzaVq, this.zzaVr, this.zzaVs, this.zzaVt});
    }

    public final String toString() {
        if (!this.zzaVp) {
            return "unset";
        }
        switch (this.format) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.value);
            }
            case 3: {
                return this.zzaIH;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzaVq).toString();
            }
            case 5: {
                return Arrays.toString(this.zzaVr);
            }
            case 6: {
                return Arrays.toString(this.zzaVs);
            }
            case 7: {
                return zzn.zza((byte[])this.zzaVt, (int)0, (int)this.zzaVt.length, (boolean)false);
            }
        }
        return "unknown";
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Bundle bundle;
        Parcel parcel2 = parcel;
        Value value = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)value.getFormat());
        zzd.zza((Parcel)parcel2, (int)2, (boolean)value.isSet());
        zzd.zza((Parcel)parcel2, (int)3, (float)value.value);
        zzd.zza((Parcel)parcel2, (int)4, (String)value.zzaIH, (boolean)false);
        Value value2 = value;
        if (value2.zzaVq == null) {
            bundle = null;
        } else {
            Bundle bundle2 = new Bundle(value2.zzaVq.size());
            for (Map.Entry<String, MapValue> entry : value2.zzaVq.entrySet()) {
                bundle2.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
            }
            bundle = bundle2;
        }
        zzd.zza((Parcel)parcel2, (int)5, bundle, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (int[])value.zzaVr, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (float[])value.zzaVs, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)value.versionCode);
        zzd.zza((Parcel)parcel2, (int)8, (byte[])value.zzaVt, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

