/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzbys;
import com.google.android.gms.internal.zzbyt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zza {
    private final int zzakw;
    private final long zzahb;
    private final long zzaTs;
    private final List<DataSource> zzaWv;
    private final List<DataType> zzaTr;
    private final List<Session> zzaWw;
    private final boolean zzaWx;
    private final boolean zzaWy;
    private final zzbys zzaWs;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzi();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.zzakw = n;
        this.zzahb = l;
        this.zzaTs = l2;
        this.zzaWv = Collections.unmodifiableList(list);
        this.zzaTr = Collections.unmodifiableList(list2);
        this.zzaWw = list3;
        this.zzaWx = bl;
        this.zzaWy = bl2;
        this.zzaWs = zzbyt.zzW(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzahb, builder.zzaTs, builder.zzaWv, builder.zzaTr, builder.zzaWw, builder.zzaWx, builder.zzaWy, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzbys zzbys2) {
        this(dataDeleteRequest.zzahb, dataDeleteRequest.zzaTs, dataDeleteRequest.zzaWv, dataDeleteRequest.zzaTr, dataDeleteRequest.zzaWw, dataDeleteRequest.zzaWx, dataDeleteRequest.zzaWy, zzbys2);
    }

    private DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzbys zzbys2) {
        this.zzakw = 3;
        this.zzahb = l;
        this.zzaTs = l2;
        this.zzaWv = Collections.unmodifiableList(list);
        this.zzaTr = Collections.unmodifiableList(list2);
        this.zzaWw = list3;
        this.zzaWx = bl;
        this.zzaWy = bl2;
        this.zzaWs = zzbys2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzahb, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTs, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaWv;
    }

    public List<DataType> getDataTypes() {
        return this.zzaTr;
    }

    public List<Session> getSessions() {
        return this.zzaWw;
    }

    public boolean deleteAllData() {
        return this.zzaWx;
    }

    public boolean deleteAllSessions() {
        return this.zzaWy;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataDeleteRequest)) break block3;
                DataDeleteRequest dataDeleteRequest = (DataDeleteRequest)((Object)object);
                DataDeleteRequest dataDeleteRequest2 = this;
                if (!(dataDeleteRequest2.zzahb == dataDeleteRequest.zzahb && dataDeleteRequest2.zzaTs == dataDeleteRequest.zzaTs && zzbh.equal(dataDeleteRequest2.zzaWv, dataDeleteRequest.zzaWv) && zzbh.equal(dataDeleteRequest2.zzaTr, dataDeleteRequest.zzaTr) && zzbh.equal(dataDeleteRequest2.zzaWw, dataDeleteRequest.zzaWw) && dataDeleteRequest2.zzaWx == dataDeleteRequest.zzaWx && dataDeleteRequest2.zzaWy == dataDeleteRequest.zzaWy)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzahb, this.zzaTs});
    }

    public String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzahb).zzg("endTimeMillis", (Object)this.zzaTs).zzg("dataSources", this.zzaWv).zzg("dateTypes", this.zzaTr).zzg("sessions", this.zzaWw).zzg("deleteAllData", (Object)this.zzaWx).zzg("deleteAllSessions", (Object)this.zzaWy).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataDeleteRequest dataDeleteRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)dataDeleteRequest.zzahb);
        zzd.zza((Parcel)parcel2, (int)2, (long)dataDeleteRequest.zzaTs);
        zzd.zzc((Parcel)parcel2, (int)3, dataDeleteRequest.getDataSources(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, dataDeleteRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, dataDeleteRequest.getSessions(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (boolean)dataDeleteRequest.zzaWx);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)dataDeleteRequest.zzaWy);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataDeleteRequest.zzakw);
        DataDeleteRequest dataDeleteRequest2 = dataDeleteRequest;
        zzd.zza((Parcel)parcel2, (int)8, (IBinder)(dataDeleteRequest2.zzaWs == null ? null : dataDeleteRequest2.zzaWs.asBinder()), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataDeleteRequest(Builder builder, zzh zzh2) {
        this(builder);
    }

    public static class Builder {
        private long zzahb;
        private long zzaTs;
        private List<DataSource> zzaWv = new ArrayList<DataSource>();
        private List<DataType> zzaTr = new ArrayList<DataType>();
        private List<Session> zzaWw = new ArrayList<Session>();
        private boolean zzaWx = false;
        private boolean zzaWy = false;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbr.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbr.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzahb = timeUnit.toMillis(l);
            this.zzaTs = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzbr.zzb((boolean)this.zzaTr.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzbr.zzb((boolean)this.zzaWv.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzaWx = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzbr.zzb((!this.zzaWx ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzbr.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzaTr.contains((Object)dataType)) {
                this.zzaTr.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzbr.zzb((!this.zzaWx ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzbr.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaWv.contains((Object)dataSource)) {
                this.zzaWv.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzbr.zzb((!this.zzaWy ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzbr.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzbr.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaWw.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzbr.zzb((boolean)this.zzaWw.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzaWy = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzbr.zza((this.zzahb > 0L && this.zzaTs > this.zzahb ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaWx || !this.zzaWv.isEmpty() || !this.zzaTr.isEmpty();
            boolean bl2 = this.zzaWy || !this.zzaWw.isEmpty();
            zzbr.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            Builder builder = this;
            if (!builder.zzaWw.isEmpty()) {
                for (Session session : builder.zzaWw) {
                    zzbr.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= builder.zzahb && session.getEndTime(TimeUnit.MILLISECONDS) <= builder.zzaTs ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, builder.zzahb, builder.zzaTs});
                }
            }
            return new DataDeleteRequest(this, null);
        }
    }
}

