/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzl;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzbxh;
import com.google.android.gms.internal.zzbxi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zza {
    public static final int NO_LIMIT = 0;
    private final int zzakw;
    private final List<DataType> zzaTr;
    private final List<DataSource> zzaWv;
    private final long zzahb;
    private final long zzaTs;
    private final List<DataType> zzaWA;
    private final List<DataSource> zzaWB;
    private final int zzaTv;
    private final long zzaWC;
    private final DataSource zzaWD;
    private final int zzaWE;
    private final boolean zzaWF;
    private final boolean zzaWG;
    private final zzbxh zzaWH;
    private final List<Device> zzaWI;
    private final List<Integer> zzaWJ;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzm();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.zzakw = n;
        this.zzaTr = list;
        this.zzaWv = list2;
        this.zzahb = l;
        this.zzaTs = l2;
        this.zzaWA = list3;
        this.zzaWB = list4;
        this.zzaTv = n2;
        this.zzaWC = l3;
        this.zzaWD = dataSource;
        this.zzaWE = n3;
        this.zzaWF = bl;
        this.zzaWG = bl2;
        this.zzaWH = iBinder == null ? null : zzbxi.zzP(iBinder);
        this.zzaWI = list5 == null ? Collections.emptyList() : list5;
        this.zzaWJ = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzaTr, builder.zzaWv, builder.zzahb, builder.zzaTs, builder.zzaWA, builder.zzaWB, builder.zzaTv, builder.zzaWC, builder.zzaWD, builder.zzaWE, false, builder.zzaWG, null, builder.zzaWI, builder.zzaWJ);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zzbxh zzbxh2) {
        this(dataReadRequest.zzaTr, dataReadRequest.zzaWv, dataReadRequest.zzahb, dataReadRequest.zzaTs, dataReadRequest.zzaWA, dataReadRequest.zzaWB, dataReadRequest.zzaTv, dataReadRequest.zzaWC, dataReadRequest.zzaWD, dataReadRequest.zzaWE, dataReadRequest.zzaWF, dataReadRequest.zzaWG, zzbxh2, dataReadRequest.zzaWI, dataReadRequest.zzaWJ);
    }

    private DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zzbxh zzbxh2, List<Device> list5, List<Integer> list6) {
        this(6, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzbxh2 == null ? null : zzbxh2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzahb, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTs, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzaTr;
    }

    public List<DataSource> getDataSources() {
        return this.zzaWv;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaWA;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaWB;
    }

    public int getBucketType() {
        return this.zzaTv;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaWC, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaWD;
    }

    public int getLimit() {
        return this.zzaWE;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadRequest)) break block3;
                DataReadRequest dataReadRequest = (DataReadRequest)((Object)object);
                DataReadRequest dataReadRequest2 = this;
                if (!(dataReadRequest2.zzaTr.equals(dataReadRequest.zzaTr) && dataReadRequest2.zzaWv.equals(dataReadRequest.zzaWv) && dataReadRequest2.zzahb == dataReadRequest.zzahb && dataReadRequest2.zzaTs == dataReadRequest.zzaTs && dataReadRequest2.zzaTv == dataReadRequest.zzaTv && dataReadRequest2.zzaWB.equals(dataReadRequest.zzaWB) && dataReadRequest2.zzaWA.equals(dataReadRequest.zzaWA) && zzbh.equal((Object)((Object)dataReadRequest2.zzaWD), (Object)((Object)dataReadRequest.zzaWD)) && dataReadRequest2.zzaWC == dataReadRequest.zzaWC && dataReadRequest2.zzaWG == dataReadRequest.zzaWG && dataReadRequest2.zzaWE == dataReadRequest.zzaWE && dataReadRequest2.zzaWF == dataReadRequest.zzaWF && zzbh.equal((Object)dataReadRequest2.zzaWH, (Object)dataReadRequest.zzaWH) && zzbh.equal(dataReadRequest2.zzaWI, dataReadRequest.zzaWI) && zzbh.equal(dataReadRequest2.zzaWJ, dataReadRequest.zzaWJ))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaTv, this.zzahb, this.zzaTs});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzaTr.isEmpty()) {
            for (DataType zza2 : this.zzaTr) {
                stringBuilder.append(zza2.zztN()).append(" ");
            }
        }
        if (!this.zzaWv.isEmpty()) {
            for (DataSource dataSource : this.zzaWv) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzaTv != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzaS(this.zzaTv));
            if (this.zzaWC > 0L) {
                stringBuilder.append(" >").append(this.zzaWC).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaWA.isEmpty()) {
            for (DataType dataType : this.zzaWA) {
                stringBuilder.append(dataType.zztN()).append(" ");
            }
        }
        if (!this.zzaWB.isEmpty()) {
            for (DataSource dataSource : this.zzaWB) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzahb, this.zzahb, this.zzaTs, this.zzaTs));
        if (this.zzaWD != null) {
            stringBuilder.append("activities: ").append(this.zzaWD.toDebugString());
        }
        if (!this.zzaWJ.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzaWJ.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzaV(n)).append(" ");
            }
        }
        if (this.zzaWG) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public List<Integer> getFilteredDataQualityStandards() {
        return this.zzaWJ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadRequest dataReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, dataReadRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, dataReadRequest.getDataSources(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)dataReadRequest.zzahb);
        zzd.zza((Parcel)parcel2, (int)4, (long)dataReadRequest.zzaTs);
        zzd.zzc((Parcel)parcel2, (int)5, dataReadRequest.getAggregatedDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, dataReadRequest.getAggregatedDataSources(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)dataReadRequest.getBucketType());
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataReadRequest.zzakw);
        zzd.zza((Parcel)parcel2, (int)8, (long)dataReadRequest.zzaWC);
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)dataReadRequest.getActivityDataSource(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)10, (int)dataReadRequest.getLimit());
        zzd.zza((Parcel)parcel2, (int)12, (boolean)dataReadRequest.zzaWF);
        zzd.zza((Parcel)parcel2, (int)13, (boolean)dataReadRequest.zzaWG);
        DataReadRequest dataReadRequest2 = dataReadRequest;
        zzd.zza((Parcel)parcel2, (int)14, (IBinder)(dataReadRequest2.zzaWH == null ? null : dataReadRequest2.zzaWH.asBinder()), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)16, dataReadRequest.zzaWI, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)17, dataReadRequest.getFilteredDataQualityStandards(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataReadRequest(Builder builder, zzl zzl2) {
        this(builder);
    }

    public static class Builder {
        private List<DataType> zzaTr = new ArrayList<DataType>();
        private List<DataSource> zzaWv = new ArrayList<DataSource>();
        private List<DataType> zzaWA = new ArrayList<DataType>();
        private List<DataSource> zzaWB = new ArrayList<DataSource>();
        private DataSource zzaWD;
        private long zzahb;
        private long zzaTs;
        private int zzaTv = 0;
        private long zzaWC = 0L;
        private int zzaWE = 0;
        private boolean zzaWF = false;
        private boolean zzaWG = false;
        private final List<Device> zzaWI = new ArrayList<Device>();
        private final List<Integer> zzaWJ = new ArrayList<Integer>();

        public Builder read(DataSource dataSource) {
            zzbr.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbr.zzb((!this.zzaWB.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaWv.contains((Object)dataSource)) {
                this.zzaWv.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbr.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbr.zza((!this.zzaWA.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzaTr.contains((Object)dataType)) {
                this.zzaTr.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzbr.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbr.zza((!this.zzaWv.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzbr.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzbr.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzaWB.contains((Object)dataSource)) {
                this.zzaWB.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzbr.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbr.zza((!this.zzaTr.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzbr.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzbr.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzaWA.contains((Object)dataType)) {
                this.zzaWA.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzbr.zzb((this.zzaTv == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTv});
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTv = 1;
            this.zzaWC = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzbr.zzb((this.zzaTv == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTv});
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTv = 3;
            this.zzaWC = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbr.zzb((this.zzaTv == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTv});
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbr.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbr.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaWD = dataSource;
            this.zzaTv = 3;
            this.zzaWC = timeUnit.toMillis(n);
            return this;
        }

        public Builder addFilteredDataQualityStandard(int n) {
            zzbr.zzb((boolean)this.zzaWI.isEmpty(), (Object)"Cannot add data quality standard filter when filtering by device.");
            this.zzaWJ.add(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzbr.zzb((this.zzaTv == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTv});
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTv = 4;
            this.zzaWC = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbr.zzb((this.zzaTv == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTv});
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbr.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbr.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaWD = dataSource;
            this.zzaTv = 4;
            this.zzaWC = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzbr.zzb((this.zzaTv == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTv});
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTv = 2;
            this.zzaWC = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzahb = timeUnit.toMillis(l);
            this.zzaTs = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaWG = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzaWE = n;
            return this;
        }

        public DataReadRequest build() {
            zzbr.zza((!this.zzaWv.isEmpty() || !this.zzaTr.isEmpty() || !this.zzaWB.isEmpty() || !this.zzaWA.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzbr.zza((this.zzahb > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzahb});
            zzbr.zza((this.zzaTs > 0L && this.zzaTs > this.zzahb ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaTs});
            boolean bl = this.zzaWB.isEmpty() && this.zzaWA.isEmpty();
            zzbr.zza((bl && this.zzaTv == 0 || !bl && this.zzaTv != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this, null);
        }
    }
}

