/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzab;
import com.google.android.gms.fitness.request.zzac;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbvr;
import com.google.android.gms.internal.zzbxq;
import com.google.android.gms.internal.zzbxr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoalsReadRequest
extends com.google.android.gms.common.internal.safeparcel.zza {
    private final int versionCode;
    private final zzbxq zzaWR;
    private final List<DataType> zzaWS;
    private final List<Integer> zzaWT;
    private final List<Integer> zzaUN;
    public static final Parcelable.Creator<GoalsReadRequest> CREATOR = new zzac();

    public List<DataType> getDataTypes() {
        return this.zzaWS;
    }

    public List<Integer> getObjectiveTypes() {
        if (this.zzaWT.isEmpty()) {
            return null;
        }
        return this.zzaWT;
    }

    public List<String> getActivityNames() {
        if (this.zzaUN.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : this.zzaUN) {
            arrayList.add(zza.getName(n));
        }
        return arrayList;
    }

    GoalsReadRequest(int n, IBinder iBinder, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this.versionCode = n;
        this.zzaWR = iBinder == null ? null : zzbxr.zzS(iBinder);
        this.zzaWS = list;
        this.zzaWT = list2;
        this.zzaUN = list3;
    }

    private GoalsReadRequest(Builder builder) {
        this(null, builder.zzaWS, builder.zzaWT, builder.zzaUN);
    }

    public GoalsReadRequest(GoalsReadRequest goalsReadRequest, zzbxq zzbxq2) {
        this(zzbxq2, goalsReadRequest.getDataTypes(), goalsReadRequest.zzaWT, goalsReadRequest.zzaUN);
    }

    private GoalsReadRequest(zzbxq zzbxq2, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this(1, zzbxq2 == null ? null : zzbxq2.asBinder(), list, list2, list3);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GoalsReadRequest)) break block3;
                GoalsReadRequest goalsReadRequest = (GoalsReadRequest)((Object)object);
                GoalsReadRequest goalsReadRequest2 = this;
                if (!(zzbh.equal(goalsReadRequest2.zzaWS, goalsReadRequest.zzaWS) && zzbh.equal(goalsReadRequest2.zzaWT, goalsReadRequest.zzaWT) && zzbh.equal(goalsReadRequest2.zzaUN, goalsReadRequest.zzaUN))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaWS, this.zzaWT, this.getActivityNames()});
    }

    public String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("dataTypes", this.zzaWS).zzg("objectiveTypes", this.zzaWT).zzg("activities", this.getActivityNames()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoalsReadRequest goalsReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (IBinder)goalsReadRequest.zzaWR.asBinder(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)2, goalsReadRequest.getDataTypes(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, goalsReadRequest.zzaWT, (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)4, goalsReadRequest.zzaUN, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)goalsReadRequest.versionCode);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ GoalsReadRequest(Builder builder, zzab zzab2) {
        this(builder);
    }

    public static class Builder {
        private final List<DataType> zzaWS = new ArrayList<DataType>();
        private final List<Integer> zzaWT = new ArrayList<Integer>();
        private final List<Integer> zzaUN = new ArrayList<Integer>();

        public Builder addDataType(DataType dataType) {
            zzbr.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaWS.contains((Object)dataType)) {
                this.zzaWS.add(dataType);
            }
            return this;
        }

        public Builder addActivity(String string) {
            int n = zza.zzcX(string);
            zzbr.zza((n != 4 ? 1 : 0) != 0, (Object)"Attempting to add an unknown activity");
            zzbvr.zza(n, this.zzaUN);
            return this;
        }

        public Builder addObjectiveType(int n) {
            zzbr.zza((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Attempting to add an invalid objective type");
            if (!this.zzaWT.contains(n)) {
                this.zzaWT.add(n);
            }
            return this;
        }

        public GoalsReadRequest build() {
            zzbr.zza((!this.zzaWS.isEmpty() ? 1 : 0) != 0, (Object)"At least one data type should be specified.");
            return new GoalsReadRequest(this, null);
        }
    }
}

