/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzau;
import com.google.android.gms.fitness.request.zzav;
import com.google.android.gms.internal.zzbym;
import com.google.android.gms.internal.zzbyn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zza {
    private final int zzakw;
    private final String zzaXn;
    private final String mSessionId;
    private final long zzahb;
    private final long zzaTs;
    private final List<DataType> zzaTr;
    private final List<DataSource> zzaWv;
    private boolean zzaXo;
    private final boolean zzaWG;
    private final List<String> zzaXp;
    private final zzbym zzaXq;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzav();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.zzakw = n;
        this.zzaXn = string;
        this.mSessionId = string2;
        this.zzahb = l;
        this.zzaTs = l2;
        this.zzaTr = list;
        this.zzaWv = list2;
        this.zzaXo = bl;
        this.zzaWG = bl2;
        this.zzaXp = list3;
        this.zzaXq = zzbyn.zzU(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzaXn, builder.mSessionId, builder.zzahb, builder.zzaTs, builder.zzaTr, builder.zzaWv, builder.zzaXo, builder.zzaWG, builder.zzaXp, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzbym zzbym2) {
        this(sessionReadRequest.zzaXn, sessionReadRequest.mSessionId, sessionReadRequest.zzahb, sessionReadRequest.zzaTs, sessionReadRequest.zzaTr, sessionReadRequest.zzaWv, sessionReadRequest.zzaXo, sessionReadRequest.zzaWG, sessionReadRequest.zzaXp, zzbym2);
    }

    private SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzbym zzbym2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzbym2 == null ? null : zzbym2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzahb, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTs, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzaXn;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public List<DataType> getDataTypes() {
        return this.zzaTr;
    }

    public List<DataSource> getDataSources() {
        return this.zzaWv;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzaXo;
    }

    public List<String> getExcludedPackages() {
        return this.zzaXp;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadRequest)) break block3;
                SessionReadRequest sessionReadRequest = (SessionReadRequest)((Object)object);
                SessionReadRequest sessionReadRequest2 = this;
                if (!(zzbh.equal((Object)sessionReadRequest2.zzaXn, (Object)sessionReadRequest.zzaXn) && sessionReadRequest2.mSessionId.equals(sessionReadRequest.mSessionId) && sessionReadRequest2.zzahb == sessionReadRequest.zzahb && sessionReadRequest2.zzaTs == sessionReadRequest.zzaTs && zzbh.equal(sessionReadRequest2.zzaTr, sessionReadRequest.zzaTr) && zzbh.equal(sessionReadRequest2.zzaWv, sessionReadRequest.zzaWv) && sessionReadRequest2.zzaXo == sessionReadRequest.zzaXo && sessionReadRequest2.zzaXp.equals(sessionReadRequest.zzaXp) && sessionReadRequest2.zzaWG == sessionReadRequest.zzaWG)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaXn, this.mSessionId, this.zzahb, this.zzaTs});
    }

    public String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("sessionName", (Object)this.zzaXn).zzg("sessionId", (Object)this.mSessionId).zzg("startTimeMillis", (Object)this.zzahb).zzg("endTimeMillis", (Object)this.zzaTs).zzg("dataTypes", this.zzaTr).zzg("dataSources", this.zzaWv).zzg("sessionsFromAllApps", (Object)this.zzaXo).zzg("excludedPackages", this.zzaXp).zzg("useServer", (Object)this.zzaWG).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadRequest sessionReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)sessionReadRequest.getSessionName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)sessionReadRequest.getSessionId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)sessionReadRequest.zzahb);
        zzd.zza((Parcel)parcel2, (int)4, (long)sessionReadRequest.zzaTs);
        zzd.zzc((Parcel)parcel2, (int)5, sessionReadRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, sessionReadRequest.getDataSources(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)sessionReadRequest.zzaXo);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)sessionReadRequest.zzakw);
        zzd.zza((Parcel)parcel2, (int)8, (boolean)sessionReadRequest.zzaWG);
        zzd.zzb((Parcel)parcel2, (int)9, sessionReadRequest.getExcludedPackages(), (boolean)false);
        SessionReadRequest sessionReadRequest2 = sessionReadRequest;
        zzd.zza((Parcel)parcel2, (int)10, (IBinder)(sessionReadRequest2.zzaXq == null ? null : sessionReadRequest2.zzaXq.asBinder()), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionReadRequest(Builder builder, zzau zzau2) {
        this(builder);
    }

    public static class Builder {
        private String zzaXn;
        private String mSessionId;
        private long zzahb = 0L;
        private long zzaTs = 0L;
        private List<DataType> zzaTr = new ArrayList<DataType>();
        private List<DataSource> zzaWv = new ArrayList<DataSource>();
        private boolean zzaXo = false;
        private boolean zzaWG = false;
        private List<String> zzaXp = new ArrayList<String>();

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzahb = timeUnit.toMillis(l);
            this.zzaTs = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzaXn = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.mSessionId = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzbr.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzaWv.contains((Object)dataSource)) {
                this.zzaWv.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbr.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaTr.contains((Object)dataType)) {
                this.zzaTr.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzaXo = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzbr.zzb((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzaXp.contains(string)) {
                this.zzaXp.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaWG = true;
            return this;
        }

        public SessionReadRequest build() {
            zzbr.zzb((this.zzahb > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzahb});
            zzbr.zzb((this.zzaTs > 0L && this.zzaTs > this.zzahb ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaTs});
            return new SessionReadRequest(this, null);
        }
    }
}

