/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzl;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzbvv;
import com.google.android.gms.internal.zzbvw;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zza {
    public static final int NO_LIMIT = 0;
    private final int zzaku;
    private final List<DataType> zzaTn;
    private final List<DataSource> zzaWr;
    private final long zzagZ;
    private final long zzaTo;
    private final List<DataType> zzaWw;
    private final List<DataSource> zzaWx;
    private final int zzaTr;
    private final long zzaWy;
    private final DataSource zzaWz;
    private final int zzaWA;
    private final boolean zzaWB;
    private final boolean zzaWC;
    private final zzbvv zzaWD;
    private final List<Device> zzaWE;
    private final List<Integer> zzaWF;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzm();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.zzaku = n;
        this.zzaTn = list;
        this.zzaWr = list2;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.zzaWw = list3;
        this.zzaWx = list4;
        this.zzaTr = n2;
        this.zzaWy = l3;
        this.zzaWz = dataSource;
        this.zzaWA = n3;
        this.zzaWB = bl;
        this.zzaWC = bl2;
        this.zzaWD = iBinder == null ? null : zzbvw.zzP(iBinder);
        this.zzaWE = list5 == null ? Collections.emptyList() : list5;
        this.zzaWF = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzaTn, builder.zzaWr, builder.zzagZ, builder.zzaTo, builder.zzaWw, builder.zzaWx, builder.zzaTr, builder.zzaWy, builder.zzaWz, builder.zzaWA, false, builder.zzaWC, null, builder.zzaWE, builder.zzaWF);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zzbvv zzbvv2) {
        this(dataReadRequest.zzaTn, dataReadRequest.zzaWr, dataReadRequest.zzagZ, dataReadRequest.zzaTo, dataReadRequest.zzaWw, dataReadRequest.zzaWx, dataReadRequest.zzaTr, dataReadRequest.zzaWy, dataReadRequest.zzaWz, dataReadRequest.zzaWA, dataReadRequest.zzaWB, dataReadRequest.zzaWC, zzbvv2, dataReadRequest.zzaWE, dataReadRequest.zzaWF);
    }

    private DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zzbvv zzbvv2, List<Device> list5, List<Integer> list6) {
        this(6, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzbvv2 == null ? null : zzbvv2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzagZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTo, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzaTn;
    }

    public List<DataSource> getDataSources() {
        return this.zzaWr;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaWw;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaWx;
    }

    public int getBucketType() {
        return this.zzaTr;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaWy, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaWz;
    }

    public int getLimit() {
        return this.zzaWA;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadRequest)) break block3;
                DataReadRequest dataReadRequest = (DataReadRequest)((Object)object);
                DataReadRequest dataReadRequest2 = this;
                if (!(dataReadRequest2.zzaTn.equals(dataReadRequest.zzaTn) && dataReadRequest2.zzaWr.equals(dataReadRequest.zzaWr) && dataReadRequest2.zzagZ == dataReadRequest.zzagZ && dataReadRequest2.zzaTo == dataReadRequest.zzaTo && dataReadRequest2.zzaTr == dataReadRequest.zzaTr && dataReadRequest2.zzaWx.equals(dataReadRequest.zzaWx) && dataReadRequest2.zzaWw.equals(dataReadRequest.zzaWw) && zzbe.equal((Object)((Object)dataReadRequest2.zzaWz), (Object)((Object)dataReadRequest.zzaWz)) && dataReadRequest2.zzaWy == dataReadRequest.zzaWy && dataReadRequest2.zzaWC == dataReadRequest.zzaWC && dataReadRequest2.zzaWA == dataReadRequest.zzaWA && dataReadRequest2.zzaWB == dataReadRequest.zzaWB && zzbe.equal((Object)dataReadRequest2.zzaWD, (Object)dataReadRequest.zzaWD) && zzbe.equal(dataReadRequest2.zzaWE, dataReadRequest.zzaWE) && zzbe.equal(dataReadRequest2.zzaWF, dataReadRequest.zzaWF))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaTr, this.zzagZ, this.zzaTo});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzaTn.isEmpty()) {
            for (DataType zza2 : this.zzaTn) {
                stringBuilder.append(zza2.zztO()).append(" ");
            }
        }
        if (!this.zzaWr.isEmpty()) {
            for (DataSource dataSource : this.zzaWr) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzaTr != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzaS(this.zzaTr));
            if (this.zzaWy > 0L) {
                stringBuilder.append(" >").append(this.zzaWy).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaWw.isEmpty()) {
            for (DataType dataType : this.zzaWw) {
                stringBuilder.append(dataType.zztO()).append(" ");
            }
        }
        if (!this.zzaWx.isEmpty()) {
            for (DataSource dataSource : this.zzaWx) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzagZ, this.zzagZ, this.zzaTo, this.zzaTo));
        if (this.zzaWz != null) {
            stringBuilder.append("activities: ").append(this.zzaWz.toDebugString());
        }
        if (!this.zzaWF.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzaWF.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzaV(n)).append(" ");
            }
        }
        if (this.zzaWC) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public List<Integer> getFilteredDataQualityStandards() {
        return this.zzaWF;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadRequest dataReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, dataReadRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, dataReadRequest.getDataSources(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)dataReadRequest.zzagZ);
        zzd.zza((Parcel)parcel2, (int)4, (long)dataReadRequest.zzaTo);
        zzd.zzc((Parcel)parcel2, (int)5, dataReadRequest.getAggregatedDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, dataReadRequest.getAggregatedDataSources(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)dataReadRequest.getBucketType());
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataReadRequest.zzaku);
        zzd.zza((Parcel)parcel2, (int)8, (long)dataReadRequest.zzaWy);
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)dataReadRequest.getActivityDataSource(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)10, (int)dataReadRequest.getLimit());
        zzd.zza((Parcel)parcel2, (int)12, (boolean)dataReadRequest.zzaWB);
        zzd.zza((Parcel)parcel2, (int)13, (boolean)dataReadRequest.zzaWC);
        DataReadRequest dataReadRequest2 = dataReadRequest;
        zzd.zza((Parcel)parcel2, (int)14, (IBinder)(dataReadRequest2.zzaWD == null ? null : dataReadRequest2.zzaWD.asBinder()), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)16, dataReadRequest.zzaWE, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)17, dataReadRequest.getFilteredDataQualityStandards(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataReadRequest(Builder builder, zzl zzl2) {
        this(builder);
    }

    public static class Builder {
        private List<DataType> zzaTn = new ArrayList<DataType>();
        private List<DataSource> zzaWr = new ArrayList<DataSource>();
        private List<DataType> zzaWw = new ArrayList<DataType>();
        private List<DataSource> zzaWx = new ArrayList<DataSource>();
        private DataSource zzaWz;
        private long zzagZ;
        private long zzaTo;
        private int zzaTr = 0;
        private long zzaWy = 0L;
        private int zzaWA = 0;
        private boolean zzaWB = false;
        private boolean zzaWC = false;
        private final List<Device> zzaWE = new ArrayList<Device>();
        private final List<Integer> zzaWF = new ArrayList<Integer>();

        public Builder read(DataSource dataSource) {
            zzbo.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbo.zzb((!this.zzaWx.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaWr.contains((Object)dataSource)) {
                this.zzaWr.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbo.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbo.zza((!this.zzaWw.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzaTn.contains((Object)dataType)) {
                this.zzaTn.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzbo.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbo.zza((!this.zzaWr.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzbo.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzbo.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzaWx.contains((Object)dataSource)) {
                this.zzaWx.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzbo.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbo.zza((!this.zzaTn.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzbo.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzbo.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzaWw.contains((Object)dataType)) {
                this.zzaWw.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzbo.zzb((this.zzaTr == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTr});
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTr = 1;
            this.zzaWy = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzbo.zzb((this.zzaTr == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTr});
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTr = 3;
            this.zzaWy = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbo.zzb((this.zzaTr == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTr});
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbo.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbo.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaWz = dataSource;
            this.zzaTr = 3;
            this.zzaWy = timeUnit.toMillis(n);
            return this;
        }

        public Builder addFilteredDataQualityStandard(int n) {
            zzbo.zzb((boolean)this.zzaWE.isEmpty(), (Object)"Cannot add data quality standard filter when filtering by device.");
            this.zzaWF.add(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzbo.zzb((this.zzaTr == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTr});
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTr = 4;
            this.zzaWy = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbo.zzb((this.zzaTr == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTr});
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbo.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbo.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaWz = dataSource;
            this.zzaTr = 4;
            this.zzaWy = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzbo.zzb((this.zzaTr == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaTr});
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaTr = 2;
            this.zzaWy = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzagZ = timeUnit.toMillis(l);
            this.zzaTo = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaWC = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzaWA = n;
            return this;
        }

        public DataReadRequest build() {
            zzbo.zza((!this.zzaWr.isEmpty() || !this.zzaTn.isEmpty() || !this.zzaWx.isEmpty() || !this.zzaWw.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzbo.zza((this.zzagZ > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzagZ});
            zzbo.zza((this.zzaTo > 0L && this.zzaTo > this.zzagZ ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaTo});
            boolean bl = this.zzaWx.isEmpty() && this.zzaWw.isEmpty();
            zzbo.zza((bl && this.zzaTr == 0 || !bl && this.zzaTr != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this, null);
        }
    }
}

