/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzbpd;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzgrj;
    private long zzgse;
    private long zzgsf;
    private final Value[] zzgsg;
    private DataSource zzgsh;
    private long zzgsi;
    private long zzgsj;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzh();

    DataPoint(int n, DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.versionCode = n;
        this.zzgrj = dataSource;
        this.zzgsh = dataSource2;
        this.zzgse = l;
        this.zzgsf = l2;
        this.zzgsg = valueArray;
        this.zzgsi = l3;
        this.zzgsj = l4;
    }

    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zzc(list, rawDataPoint.zzgvi), DataPoint.zzc(list, rawDataPoint.zzgvj), rawDataPoint);
    }

    private DataPoint(DataSource dataSource, DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzgvf, 0L), DataPoint.zza(rawDataPoint.zzgvg, 0L), rawDataPoint.zzgvh, dataSource2, DataPoint.zza(rawDataPoint.zzgvk, 0L), DataPoint.zza(rawDataPoint.zzgvl, 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private DataPoint(DataSource dataSource) {
        this.versionCode = 4;
        this.zzgrj = (DataSource)((Object)zzbp.zzb((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        List<Field> list = dataSource.getDataType().getFields();
        this.zzgsg = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzgsg[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zze.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public final DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzgse = timeUnit.toNanos(l);
        if (this.getDataType() == DataType.TYPE_LOCATION_SAMPLE && zzbpd.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzgse = zzbpd.zza(this.zzgse, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public final DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzgsf = timeUnit.toNanos(l);
        this.zzgse = timeUnit.toNanos(l2);
        return this;
    }

    public final Value zzcw(int n) {
        DataType dataType = this.getDataType();
        if (n < 0 || n >= dataType.getFields().size()) {
            throw new IllegalArgumentException(String.format("fieldIndex %s is out of range for %s", new Object[]{n, dataType}));
        }
        return this.zzgsg[n];
    }

    public final Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzgsg[n];
    }

    public final Value[] zzaoj() {
        return this.zzgsg;
    }

    public final DataPoint setFloatValues(float ... fArray) {
        this.zzcx(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzgsg[i].setFloat(fArray[i]);
        }
        return this;
    }

    public final DataPoint setIntValues(int ... nArray) {
        this.zzcx(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzgsg[i].setInt(nArray[i]);
        }
        return this;
    }

    private final void zzcx(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzbp.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public final DataType getDataType() {
        return this.zzgrj.getDataType();
    }

    public final DataSource getDataSource() {
        return this.zzgrj;
    }

    public final DataSource getOriginalDataSource() {
        if (this.zzgsh != null) {
            return this.zzgsh;
        }
        return this.zzgrj;
    }

    public final DataSource zzaok() {
        return this.zzgsh;
    }

    public final long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgse, TimeUnit.NANOSECONDS);
    }

    public final long zzaol() {
        return this.zzgsi;
    }

    public final long zzaom() {
        return this.zzgsj;
    }

    public final long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgsf, TimeUnit.NANOSECONDS);
    }

    public final long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgse, TimeUnit.NANOSECONDS);
    }

    public final void zzaon() {
        DataSource dataSource = this.getDataSource();
        zzbp.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzbp.zzb((this.zzgse > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzbp.zzb((this.zzgsf <= this.zzgse ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataPoint)) break block3;
                DataPoint dataPoint = (DataPoint)((Object)object);
                DataPoint dataPoint2 = this;
                if (!(zzbf.equal((Object)((Object)dataPoint2.zzgrj), (Object)((Object)dataPoint.zzgrj)) && dataPoint2.zzgse == dataPoint.zzgse && dataPoint2.zzgsf == dataPoint.zzgsf && Arrays.equals((Object[])dataPoint2.zzgsg, (Object[])dataPoint.zzgsg) && zzbf.equal((Object)((Object)dataPoint2.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource())))) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgrj, this.zzgse, this.zzgsf});
    }

    public final String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzgsg), this.zzgsf, this.zzgse, this.zzgsi, this.zzgsj, this.zzgrj.toDebugString(), this.zzgsh != null ? this.zzgsh.toDebugString() : "N/A");
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataPoint dataPoint = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)dataPoint.getDataSource(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)dataPoint.zzgse);
        zzd.zza((Parcel)parcel2, (int)4, (long)dataPoint.zzgsf);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable[])dataPoint.zzgsg, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (Parcelable)dataPoint.zzgsh, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (long)dataPoint.zzgsi);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataPoint.versionCode);
        zzd.zza((Parcel)parcel2, (int)8, (long)dataPoint.zzgsj);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    private static long zza(Long l, long l2) {
        if (l != null) {
            return l;
        }
        return 0L;
    }
}

