/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzbpi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzgrj;
    private final DataType zzgri;
    private final List<DataPoint> zzgsk;
    private final List<DataSource> zzgsl;
    private boolean zzgsm = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.zzgrj = dataSource;
        this.zzgri = dataSource.getDataType();
        this.zzgsm = bl;
        this.zzgsk = new ArrayList<DataPoint>(list.size());
        this.zzgsl = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzgsk.add(new DataPoint(this.zzgsl, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.zzgrj = (DataSource)((Object)zzbp.zzu((Object)((Object)dataSource)));
        this.zzgri = dataSource.getDataType();
        this.zzgsk = new ArrayList<DataPoint>();
        this.zzgsl = new ArrayList<DataSource>();
        this.zzgsl.add(this.zzgrj);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        int n = rawDataSet.zzgvi;
        List<DataSource> list2 = list;
        this.zzgrj = n >= 0 && n < list2.size() ? list2.get(n) : null;
        this.zzgri = this.zzgrj.getDataType();
        this.zzgsl = list;
        this.zzgsm = rawDataSet.zzgsb;
        List<RawDataPoint> list3 = rawDataSet.zzgvn;
        this.zzgsk = new ArrayList<DataPoint>(list3.size());
        for (RawDataPoint rawDataPoint : list3) {
            this.zzgsk.add(new DataPoint(this.zzgsl, rawDataPoint));
        }
    }

    public static DataSet create(DataSource dataSource) {
        zzbp.zzb((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public final DataPoint createDataPoint() {
        return DataPoint.create(this.zzgrj);
    }

    public final void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzbp.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzgrj.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzgrj});
        dataPoint.zzaon();
        DataSet.zzb(dataPoint);
        this.zza(dataPoint);
    }

    private final void zza(DataPoint dataPoint) {
        this.zzgsk.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzgsl.contains((Object)dataSource)) {
            this.zzgsl.add(dataSource);
        }
    }

    public final void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public final void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zza(dataPoint);
        }
    }

    public final DataSource getDataSource() {
        return this.zzgrj;
    }

    public final DataType getDataType() {
        return this.zzgrj.getDataType();
    }

    public final List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzgsk);
    }

    public final boolean isEmpty() {
        return this.zzgsk.isEmpty();
    }

    public final boolean zzaoh() {
        return this.zzgsm;
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataSet)) break block3;
                DataSet dataSet = (DataSet)((Object)object);
                DataSet dataSet2 = this;
                if (!(zzbf.equal((Object)((Object)dataSet2.getDataType()), (Object)((Object)dataSet.getDataType())) && zzbf.equal((Object)((Object)dataSet2.zzgrj), (Object)((Object)dataSet.zzgrj)) && zzbf.equal(dataSet2.zzgsk, dataSet.zzgsk) && dataSet2.zzgsm == dataSet.zzgsm)) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgrj});
    }

    public final String toString() {
        List<RawDataPoint> list = this.zzaoo();
        return String.format("DataSet{%s %s}", this.zzgrj.toDebugString(), this.zzgsk.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzgsk.size(), list.subList(0, 5)));
    }

    public static void zzb(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzbpi.zza(dataPoint, zzf.zzgsc);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    private List<RawDataPoint> zzaoo() {
        return this.zzy(this.zzgsl);
    }

    final List<RawDataPoint> zzy(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzgsk.size());
        for (DataPoint dataPoint : this.zzgsk) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSet dataSet = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)dataSet.getDataSource(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)dataSet.getDataType(), (int)n, (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, dataSet.zzaoo(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, dataSet.zzgsl, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (boolean)dataSet.zzgsm);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataSet.versionCode);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

