/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.data.zzk;

public class DataSource
extends zza {
    private static final int[] zzgsn = new int[0];
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_ESH2002 = 1;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_ESH2010 = 2;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_AAMI = 3;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_A_A = 4;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_A_B = 5;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_B_A = 6;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_B_B = 7;
    public static final int DATA_QUALITY_BLOOD_GLUCOSE_ISO151972003 = 8;
    public static final int DATA_QUALITY_BLOOD_GLUCOSE_ISO151972013 = 9;
    private final int versionCode;
    private final DataType zzgri;
    private final String name;
    private final int type;
    private final Device zzgso;
    private final zzb zzgsp;
    private final String zzgsq;
    private final int[] zzgsr;
    private final String zzgss;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzk();

    DataSource(int n, DataType dataType, String string, int n2, Device device, zzb zzb2, String string2, int[] nArray) {
        this.versionCode = n;
        this.zzgri = dataType;
        this.type = n2;
        this.name = string;
        this.zzgso = device;
        this.zzgsp = zzb2;
        this.zzgsq = string2;
        this.zzgss = this.zzaoq();
        this.zzgsr = nArray != null ? nArray : zzgsn;
    }

    private DataSource(Builder builder) {
        this.versionCode = 3;
        this.zzgri = builder.zzgri;
        this.type = builder.type;
        this.name = builder.name;
        this.zzgso = builder.zzgso;
        this.zzgsp = builder.zzgsp;
        this.zzgsq = builder.zzgsq;
        this.zzgss = this.zzaoq();
        this.zzgsr = builder.zzgsr;
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zze.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzgri;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAppPackageName() {
        if (this.zzgsp == null) {
            return null;
        }
        return this.zzgsp.getPackageName();
    }

    public final zzb zzaop() {
        return this.zzgsp;
    }

    public Device getDevice() {
        return this.zzgso;
    }

    public String getStreamName() {
        return this.zzgsq;
    }

    public int[] getDataQualityStandards() {
        return this.zzgsr;
    }

    public String getStreamIdentifier() {
        return this.zzgss;
    }

    private final String zzaoq() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzgri.getName());
        if (this.zzgsp != null) {
            stringBuilder.append(":").append(this.zzgsp.getPackageName());
        }
        if (this.zzgso != null) {
            stringBuilder.append(":").append(this.zzgso.getStreamIdentifier());
        }
        if (this.zzgsq != null) {
            stringBuilder.append(":").append(this.zzgsq);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataSource)) break block3;
                DataSource dataSource = (DataSource)((Object)object);
                if (!this.zzgss.equals(dataSource.zzgss)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.zzgss.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.name != null) {
            stringBuilder.append(":").append(this.name);
        }
        if (this.zzgsp != null) {
            stringBuilder.append(":").append((Object)this.zzgsp);
        }
        if (this.zzgso != null) {
            stringBuilder.append(":").append((Object)this.zzgso);
        }
        if (this.zzgsq != null) {
            stringBuilder.append(":").append(this.zzgsq);
        }
        stringBuilder.append(":").append((Object)this.zzgri);
        return stringBuilder.append("}").toString();
    }

    public final String toDebugString() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        switch (this.type) {
            case 0: {
                string7 = "r";
                break;
            }
            case 1: {
                string7 = "d";
                break;
            }
            case 2: {
                string7 = "c";
                break;
            }
            case 3: {
                string7 = "v";
                break;
            }
            default: {
                string7 = "?";
            }
        }
        String string8 = string7;
        String string9 = this.zzgri.zzaor();
        if (this.zzgsp == null) {
            string6 = "";
        } else if (this.zzgsp.equals((Object)zzb.zzgrs)) {
            string6 = ":gms";
        } else {
            String string10 = String.valueOf(this.zzgsp.getPackageName());
            string6 = string5 = string10.length() != 0 ? ":".concat(string10) : new String(":");
        }
        if (this.zzgso != null) {
            string4 = this.zzgso.getModel();
            string3 = this.zzgso.getUid();
            string2 = new StringBuilder(2 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(":").append(string4).append(":").append(string3).toString();
        } else {
            string2 = string4 = "";
        }
        if (this.zzgsq != null) {
            String string11 = String.valueOf(this.zzgsq);
            string = string11.length() != 0 ? ":".concat(string11) : new String(":");
        } else {
            string = "";
        }
        string3 = string;
        return new StringBuilder(1 + String.valueOf(string8).length() + String.valueOf(string9).length() + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string8).append(":").append(string9).append(string5).append(string4).append(string3).toString();
    }

    public static String zzcy(int n) {
        switch (n) {
            case 1: {
                return "blood_pressure_esh2002";
            }
            case 2: {
                return "blood_pressure_esh2010";
            }
            case 3: {
                return "blood_pressure_aami";
            }
            case 4: {
                return "blood_pressure_bhs_a_a";
            }
            case 5: {
                return "blood_pressure_bhs_a_b";
            }
            case 6: {
                return "blood_pressure_bhs_b_a";
            }
            case 7: {
                return "blood_pressure_bhs_b_b";
            }
            case 8: {
                return "blood_glucose_iso151972003";
            }
            case 9: {
                return "blood_glucose_iso151972013";
            }
        }
        return "unknown";
    }

    private final String getTypeString() {
        switch (this.type) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
            case 2: {
                return "cleaned";
            }
            case 3: {
                return "converted";
            }
        }
        return "derived";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSource dataSource = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)dataSource.getDataType(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)dataSource.getName(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)dataSource.getType());
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)dataSource.getDevice(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)dataSource.zzgsp, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)dataSource.getStreamName(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataSource.versionCode);
        zzd.zza((Parcel)parcel2, (int)8, (int[])dataSource.getDataQualityStandards(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataSource(Builder builder, zzj zzj2) {
        this(builder);
    }

    public static final class Builder {
        private DataType zzgri;
        private int type = -1;
        private String name;
        private Device zzgso;
        private zzb zzgsp;
        private String zzgsq = "";
        private int[] zzgsr;

        public Builder() {
        }

        public final Builder setDataType(DataType dataType) {
            this.zzgri = dataType;
            return this;
        }

        public final Builder setType(int n) {
            this.type = n;
            return this;
        }

        public final Builder setName(String string) {
            this.name = string;
            return this;
        }

        public final Builder setDevice(Device device) {
            this.zzgso = device;
            return this;
        }

        public final Builder setAppPackageName(String string) {
            this.zzgsp = zzb.zzgx(string);
            return this;
        }

        public final Builder setAppPackageName(Context context) {
            return this.setAppPackageName(context.getPackageName());
        }

        public final Builder setStreamName(String string) {
            zzbp.zzb((string != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzgsq = string;
            return this;
        }

        public final Builder setDataQualityStandards(int ... nArray) {
            this.zzgsr = nArray;
            return this;
        }

        public final DataSource build() {
            zzbp.zza((this.zzgri != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzbp.zza((this.type >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this, null);
        }
    }
}

