/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.zzac;
import com.google.android.gms.fitness.data.zzad;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.zza;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Session
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzdxt;
    private final long zzdqy;
    private final long zzgrx;
    private final String mName;
    private final String zzgvo;
    private final String zzdmz;
    private final int zzgry;
    private final zzb zzgvp;
    private final Long zzgvq;
    public static final Parcelable.Creator<Session> CREATOR = new zzad();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, zzb zzb2, Long l3) {
        this.zzdxt = n;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.mName = string;
        this.zzgvo = string2;
        this.zzdmz = string3;
        this.zzgry = n2;
        this.zzgvp = zzb2;
        this.zzgvq = l3;
    }

    private Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, Long l3) {
        this(3, l, l2, string, string2, string3, n, null, l3);
    }

    private Session(Builder builder) {
        this(builder.zzdqy, builder.zzgrx, builder.mName, builder.zzgvo, builder.zzdmz, builder.zzgry, null, builder.zzgvq);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zze.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdqy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgrx, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzbp.zza((this.zzgvq != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzgvq, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzgvq != null;
    }

    public boolean isOngoing() {
        return this.zzgrx == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzgvo;
    }

    public String getDescription() {
        return this.zzdmz;
    }

    public String getActivity() {
        return zza.getName(this.zzgry);
    }

    public String getAppPackageName() {
        if (this.zzgvp == null) {
            return null;
        }
        return this.zzgvp.getPackageName();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Session)) break block3;
                Session session = (Session)((Object)object);
                Session session2 = this;
                if (!(session2.zzdqy == session.zzdqy && session2.zzgrx == session.zzgrx && zzbf.equal((Object)session2.mName, (Object)session.mName) && zzbf.equal((Object)session2.zzgvo, (Object)session.zzgvo) && zzbf.equal((Object)session2.zzdmz, (Object)session.zzdmz) && zzbf.equal((Object)((Object)session2.zzgvp), (Object)((Object)session.zzgvp)) && session2.zzgry == session.zzgry)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdqy, this.zzgrx, this.zzgvo});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("startTime", (Object)this.zzdqy).zzg("endTime", (Object)this.zzgrx).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzgvo).zzg("description", (Object)this.zzdmz).zzg("activity", (Object)this.zzgry).zzg("application", (Object)this.zzgvp).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Session session = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)session.zzdqy);
        zzd.zza((Parcel)parcel2, (int)2, (long)session.zzgrx);
        zzd.zza((Parcel)parcel2, (int)3, (String)session.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)session.getIdentifier(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)session.getDescription(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)session.zzgry);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)session.zzdxt);
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)session.zzgvp, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (Long)session.zzgvq, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ Session(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private long zzdqy = 0L;
        private long zzgrx = 0L;
        private String mName = null;
        private String zzgvo;
        private String zzdmz;
        private int zzgry = 4;
        private Long zzgvq;

        public Builder() {
        }

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzbp.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzdqy = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzbp.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzgrx = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzbp.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzbp.zzbh((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzgvo = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzbp.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzdmz = string;
            return this;
        }

        public Builder setActivity(String string) {
            int n = zza.zzgw(string);
            Builder builder = this;
            this.zzgry = n;
            return builder;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzgvq = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzbp.zza((this.zzdqy > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzbp.zza((this.zzgrx == 0L || this.zzgrx > this.zzdqy ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzgvo == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.zzdqy;
                this.zzgvo = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.zzdmz == null) {
                this.zzdmz = "";
            }
            return new Session(this, null);
        }
    }
}

