/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzk;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzai;
import com.google.android.gms.fitness.zza;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends com.google.android.gms.common.internal.safeparcel.zza {
    private final int versionCode;
    private final int format;
    private boolean zzgvu;
    private float value;
    private String zzfwi;
    private Map<String, MapValue> zzgvv;
    private int[] zzgvw;
    private float[] zzgvx;
    private byte[] zzgvy;
    public static final Parcelable.Creator<Value> CREATOR = new zzai();

    public Value(int n) {
        this(3, n, false, 0.0f, null, null, null, null, null);
    }

    Value(int n, int n2, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        ArrayMap arrayMap;
        this.versionCode = n;
        this.format = n2;
        this.zzgvu = bl;
        this.value = f;
        this.zzfwi = string;
        Bundle bundle2 = bundle;
        if (bundle2 == null) {
            arrayMap = null;
        } else {
            bundle2.setClassLoader(MapValue.class.getClassLoader());
            ArrayMap arrayMap2 = new ArrayMap(bundle2.size());
            for (String string2 : bundle2.keySet()) {
                arrayMap2.put(string2, (MapValue)bundle2.getParcelable(string2));
            }
            arrayMap = arrayMap2;
        }
        this.zzgvv = arrayMap;
        this.zzgvw = nArray;
        this.zzgvx = fArray;
        this.zzgvy = byArray;
    }

    public final void setInt(int n) {
        zzbp.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzgvu = true;
        this.value = Float.intBitsToFloat(n);
    }

    public final void setFloat(float f) {
        zzbp.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzgvu = true;
        this.value = f;
    }

    public final void setString(String string) {
        zzbp.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzgvu = true;
        this.zzfwi = string;
    }

    public final void setKeyValue(String string, float f) {
        zzbp.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzgvu = true;
        if (this.zzgvv == null) {
            this.zzgvv = new HashMap<String, MapValue>();
        }
        this.zzgvv.put(string, new MapValue(2, f));
    }

    public final void clearKey(String string) {
        zzbp.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzgvv != null) {
            this.zzgvv.remove(string);
        }
    }

    public final void setActivity(String string) {
        this.setInt(zza.zzgw(string));
    }

    public final boolean isSet() {
        return this.zzgvu;
    }

    public final int getFormat() {
        return this.format;
    }

    public final int asInt() {
        zzbp.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.value);
    }

    public final float asFloat() {
        zzbp.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.value;
    }

    public final String asString() {
        zzbp.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzfwi;
    }

    @Nullable
    public final Float getKeyValue(String string) {
        zzbp.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzgvv != null && this.zzgvv.containsKey(string)) {
            return Float.valueOf(this.zzgvv.get(string).asFloat());
        }
        return null;
    }

    public final String asActivity() {
        return zza.getName(this.asInt());
    }

    public final boolean equals(Object object) {
        block18: {
            block17: {
                boolean bl;
                if (this == object) break block17;
                if (!(object instanceof Value)) break block18;
                Value value = (Value)((Object)object);
                Value value2 = this;
                if (value2.format == value.format && value2.zzgvu == value.zzgvu) {
                    switch (value2.format) {
                        case 1: {
                            if (value2.asInt() == value.asInt()) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 2: {
                            if (value2.value == value.value) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 3: {
                            bl = zzbf.equal((Object)value2.zzfwi, (Object)value.zzfwi);
                            break;
                        }
                        case 4: {
                            bl = zzbf.equal(value2.zzgvv, value.zzgvv);
                            break;
                        }
                        case 5: {
                            bl = Arrays.equals(value2.zzgvw, value.zzgvw);
                            break;
                        }
                        case 6: {
                            bl = Arrays.equals(value2.zzgvx, value.zzgvx);
                            break;
                        }
                        case 7: {
                            bl = Arrays.equals(value2.zzgvy, value.zzgvy);
                            break;
                        }
                        default: {
                            if (value2.value == value.value) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                    }
                } else {
                    bl = false;
                }
                if (!bl) break block18;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.value), this.zzfwi, this.zzgvv, this.zzgvw, this.zzgvx, this.zzgvy});
    }

    public final String toString() {
        if (!this.zzgvu) {
            return "unset";
        }
        switch (this.format) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.value);
            }
            case 3: {
                return this.zzfwi;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzgvv).toString();
            }
            case 5: {
                return Arrays.toString(this.zzgvw);
            }
            case 6: {
                return Arrays.toString(this.zzgvx);
            }
            case 7: {
                return zzk.zza((byte[])this.zzgvy, (int)0, (int)this.zzgvy.length, (boolean)false);
            }
        }
        return "unknown";
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Bundle bundle;
        Parcel parcel2 = parcel;
        Value value = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)value.getFormat());
        zzd.zza((Parcel)parcel2, (int)2, (boolean)value.isSet());
        zzd.zza((Parcel)parcel2, (int)3, (float)value.value);
        zzd.zza((Parcel)parcel2, (int)4, (String)value.zzfwi, (boolean)false);
        Value value2 = value;
        if (value2.zzgvv == null) {
            bundle = null;
        } else {
            Bundle bundle2 = new Bundle(value2.zzgvv.size());
            for (Map.Entry<String, MapValue> entry : value2.zzgvv.entrySet()) {
                bundle2.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
            }
            bundle = bundle2;
        }
        zzd.zza((Parcel)parcel2, (int)5, bundle, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (int[])value.zzgvw, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (float[])value.zzgvx, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)value.versionCode);
        zzd.zza((Parcel)parcel2, (int)8, (byte[])value.zzgvy, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

