/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzx;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.internal.zzbsf;
import com.google.android.gms.internal.zzbsg;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zza {
    private final int zzdxt;
    private final long zzdqy;
    private final long zzgrx;
    private final DataSet zzgvr;
    private final zzbsf zzgxx;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzy();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzdxt = n;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.zzgvr = dataSet;
        this.zzgxx = zzbsg.zzay(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzdqy, builder.zzgrx, builder.zzgvr, null);
    }

    private DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzdxt = 1;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.zzgvr = dataSet;
        this.zzgxx = zzbsg.zzay(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzdqy, dataUpdateRequest.zzgrx, dataUpdateRequest.getDataSet(), iBinder);
    }

    public final long zzzg() {
        return this.zzdqy;
    }

    public final long zzaox() {
        return this.zzgrx;
    }

    public DataSet getDataSet() {
        return this.zzgvr;
    }

    public IBinder getCallbackBinder() {
        if (this.zzgxx == null) {
            return null;
        }
        return this.zzgxx.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdqy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgrx, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataUpdateRequest)) break block3;
                DataUpdateRequest dataUpdateRequest = (DataUpdateRequest)((Object)object);
                DataUpdateRequest dataUpdateRequest2 = this;
                if (!(dataUpdateRequest2.zzdqy == dataUpdateRequest.zzdqy && dataUpdateRequest2.zzgrx == dataUpdateRequest.zzgrx && zzbf.equal((Object)((Object)dataUpdateRequest2.zzgvr), (Object)((Object)dataUpdateRequest.zzgvr)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdqy, this.zzgrx, this.zzgvr});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzdqy).zzg("endTimeMillis", (Object)this.zzgrx).zzg("dataSet", (Object)this.zzgvr).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataUpdateRequest dataUpdateRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)dataUpdateRequest.zzdqy);
        zzd.zza((Parcel)parcel2, (int)2, (long)dataUpdateRequest.zzgrx);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)dataUpdateRequest.getDataSet(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (IBinder)dataUpdateRequest.getCallbackBinder(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataUpdateRequest.zzdxt);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataUpdateRequest(Builder builder, zzx zzx2) {
        this(builder);
    }

    public static class Builder {
        private long zzdqy;
        private long zzgrx;
        private DataSet zzgvr;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbp.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbp.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzdqy = timeUnit.toMillis(l);
            this.zzgrx = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzbp.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzgvr = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            Builder builder = this;
            zzbp.zza((long)builder.zzdqy, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzbp.zza((long)builder.zzgrx, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzbp.zzb((Object)((Object)builder.zzgvr), (Object)"Must set the data set");
            for (DataPoint dataPoint : builder.zzgvr.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                zzbp.zza((!(l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < builder.zzdqy || l2 != 0L && l2 > builder.zzgrx || l > builder.zzgrx || l < builder.zzdqy) ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, builder.zzdqy, builder.zzgrx});
            }
            return new DataUpdateRequest(this, null);
        }
    }
}

