/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzas;
import com.google.android.gms.fitness.request.zzat;
import com.google.android.gms.internal.zzbpd;
import com.google.android.gms.internal.zzbsf;
import com.google.android.gms.internal.zzbsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends zza {
    private final int versionCode;
    private final Session zzgzn;
    private final List<DataSet> zzgzo;
    private final List<DataPoint> zzgzp;
    private final zzbsf zzgzq;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzat();

    SessionInsertRequest(int n, Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.versionCode = n;
        this.zzgzn = session;
        this.zzgzo = Collections.unmodifiableList(list);
        this.zzgzp = Collections.unmodifiableList(list2);
        this.zzgzq = zzbsg.zzay(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzgzn, builder.zzgzo, builder.zzgzp, null);
    }

    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzbsf zzbsf2) {
        this(sessionInsertRequest.zzgzn, sessionInsertRequest.zzgzo, sessionInsertRequest.zzgzp, zzbsf2);
    }

    private SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, zzbsf zzbsf2) {
        this.versionCode = 3;
        this.zzgzn = session;
        this.zzgzo = Collections.unmodifiableList(list);
        this.zzgzp = Collections.unmodifiableList(list2);
        this.zzgzq = zzbsf2;
    }

    public Session getSession() {
        return this.zzgzn;
    }

    public List<DataSet> getDataSets() {
        return this.zzgzo;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzgzp;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof SessionInsertRequest)) break block3;
                SessionInsertRequest sessionInsertRequest = (SessionInsertRequest)((Object)object);
                SessionInsertRequest sessionInsertRequest2 = this;
                if (!(zzbf.equal((Object)((Object)sessionInsertRequest2.zzgzn), (Object)((Object)sessionInsertRequest.zzgzn)) && zzbf.equal(sessionInsertRequest2.zzgzo, sessionInsertRequest.zzgzo) && zzbf.equal(sessionInsertRequest2.zzgzp, sessionInsertRequest.zzgzp))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgzn, this.zzgzo, this.zzgzp});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("session", (Object)this.zzgzn).zzg("dataSets", this.zzgzo).zzg("aggregateDataPoints", this.zzgzp).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionInsertRequest sessionInsertRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)sessionInsertRequest.getSession(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, sessionInsertRequest.getDataSets(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, sessionInsertRequest.getAggregateDataPoints(), (boolean)false);
        SessionInsertRequest sessionInsertRequest2 = sessionInsertRequest;
        zzd.zza((Parcel)parcel2, (int)4, (IBinder)(sessionInsertRequest2.zzgzq == null ? null : sessionInsertRequest2.zzgzq.asBinder()), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)sessionInsertRequest.versionCode);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionInsertRequest(Builder builder, zzas zzas2) {
        this(builder);
    }

    public static class Builder {
        private Session zzgzn;
        private List<DataSet> zzgzo = new ArrayList<DataSet>();
        private List<DataPoint> zzgzp = new ArrayList<DataPoint>();
        private List<DataSource> zzgzr = new ArrayList<DataSource>();

        public Builder() {
        }

        public Builder setSession(Session session) {
            this.zzgzn = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzbp.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzbp.zza((!this.zzgzr.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            zzbp.zzb((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzgzr.add(dataSource);
            this.zzgzo.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzbp.zzb((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzbp.zza((!this.zzgzr.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zzb(dataPoint);
            this.zzgzr.add(dataSource);
            this.zzgzp.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzbp.zza((this.zzgzn != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzbp.zza((this.zzgzn.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            Builder builder = this;
            Iterator<zza> iterator = builder.zzgzo.iterator();
            while (iterator.hasNext()) {
                for (DataPoint dataPoint : iterator.next().getDataPoints()) {
                    builder.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : builder.zzgzp) {
                builder.zzd(dataPoint);
            }
            return new SessionInsertRequest(this, null);
        }

        private final void zzd(DataPoint dataPoint) {
            DataPoint dataPoint2 = dataPoint;
            Builder builder = this;
            long l = builder.zzgzn.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = builder.zzgzn.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint2.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzbpd.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbp.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (dataPoint2.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint2.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
            dataPoint2 = dataPoint;
            builder = this;
            l = builder.zzgzn.getStartTime(TimeUnit.NANOSECONDS);
            l2 = builder.zzgzn.getEndTime(TimeUnit.NANOSECONDS);
            l3 = dataPoint2.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint2.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzbpd.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbp.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (l4 != dataPoint2.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint2.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }
    }
}

