/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
extends zza
implements Result {
    private final int zzdxt;
    private final List<Subscription> zzhaj;
    private final Status mStatus;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzg();

    ListSubscriptionsResult(int n, List<Subscription> list, Status status) {
        this.zzdxt = n;
        this.zzhaj = list;
        this.mStatus = status;
    }

    private ListSubscriptionsResult(List<Subscription> list, Status status) {
        this.zzdxt = 3;
        this.zzhaj = Collections.unmodifiableList(list);
        this.mStatus = (Status)zzbp.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzad(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzhaj;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzhaj) {
            if (!dataType.equals((Object)subscription.zzaos())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ListSubscriptionsResult)) break block3;
                ListSubscriptionsResult listSubscriptionsResult = (ListSubscriptionsResult)((Object)object);
                ListSubscriptionsResult listSubscriptionsResult2 = this;
                if (!(listSubscriptionsResult2.mStatus.equals((Object)listSubscriptionsResult.mStatus) && zzbf.equal(listSubscriptionsResult2.zzhaj, listSubscriptionsResult.zzhaj))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzhaj});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("status", (Object)this.mStatus).zzg("subscriptions", this.zzhaj).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ListSubscriptionsResult listSubscriptionsResult = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, listSubscriptionsResult.getSubscriptions(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)listSubscriptionsResult.getStatus(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)listSubscriptionsResult.zzdxt);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

