/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzt;
import com.google.android.gms.fitness.data.zzu;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zzb;
import com.google.android.gms.fitness.service.zzc;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
extends zza {
    public static final int UNSPECIFIED = -1;
    private final int zzdxt;
    private final DataSource zzgtm;
    private final zzt zzgze;
    private final long zzhan;
    private final long zzhao;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zzb();

    FitnessSensorServiceRequest(int n, DataSource dataSource, IBinder iBinder, long l, long l2) {
        this.zzdxt = n;
        this.zzgtm = dataSource;
        this.zzgze = zzu.zzap(iBinder);
        this.zzhan = l;
        this.zzhao = l2;
    }

    public DataSource getDataSource() {
        return this.zzgtm;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzc(this.zzgze);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        if (this.zzhan == -1L) {
            return -1L;
        }
        return timeUnit.convert(this.zzhan, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhao, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", new Object[]{this.zzgtm});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        FitnessSensorServiceRequest fitnessSensorServiceRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)fitnessSensorServiceRequest.getDataSource(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (IBinder)fitnessSensorServiceRequest.zzgze.asBinder(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)fitnessSensorServiceRequest.zzhan);
        zzd.zza((Parcel)parcel2, (int)4, (long)fitnessSensorServiceRequest.zzhao);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)fitnessSensorServiceRequest.zzdxt);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FitnessSensorServiceRequest)) break block3;
                FitnessSensorServiceRequest fitnessSensorServiceRequest = (FitnessSensorServiceRequest)((Object)object);
                FitnessSensorServiceRequest fitnessSensorServiceRequest2 = this;
                if (!(zzbf.equal((Object)((Object)fitnessSensorServiceRequest2.zzgtm), (Object)((Object)fitnessSensorServiceRequest.zzgtm)) && fitnessSensorServiceRequest2.zzhan == fitnessSensorServiceRequest.zzhan && fitnessSensorServiceRequest2.zzhao == fitnessSensorServiceRequest.zzhao)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgtm, this.zzhan, this.zzhao});
    }
}

