/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.fitness.BleApi;
import com.google.android.gms.fitness.BleClient;
import com.google.android.gms.fitness.ConfigApi;
import com.google.android.gms.fitness.ConfigClient;
import com.google.android.gms.fitness.FitnessOptions;
import com.google.android.gms.fitness.GoalsApi;
import com.google.android.gms.fitness.GoalsClient;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.HistoryClient;
import com.google.android.gms.fitness.RecordingApi;
import com.google.android.gms.fitness.RecordingClient;
import com.google.android.gms.fitness.SensorsApi;
import com.google.android.gms.fitness.SensorsClient;
import com.google.android.gms.fitness.SessionsApi;
import com.google.android.gms.fitness.SessionsClient;
import com.google.android.gms.internal.zzbve;
import com.google.android.gms.internal.zzbvk;
import com.google.android.gms.internal.zzbvq;
import com.google.android.gms.internal.zzbvv;
import com.google.android.gms.internal.zzbwb;
import com.google.android.gms.internal.zzbwh;
import com.google.android.gms.internal.zzbwn;
import com.google.android.gms.internal.zzbyi;
import com.google.android.gms.internal.zzbyq;
import com.google.android.gms.internal.zzbyv;
import com.google.android.gms.internal.zzbyy;
import com.google.android.gms.internal.zzbzi;
import com.google.android.gms.internal.zzbzp;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzcaf;
import java.util.concurrent.TimeUnit;

public class Fitness {
    @Deprecated
    public static final Void API = null;
    public static final Api<Api.ApiOptions.NoOptions> SENSORS_API = zzbwh.API;
    public static final SensorsApi SensorsApi = new zzbzp();
    public static final Api<Api.ApiOptions.NoOptions> RECORDING_API = zzbwb.API;
    public static final RecordingApi RecordingApi = new zzbzi();
    public static final Api<Api.ApiOptions.NoOptions> SESSIONS_API = zzbwn.API;
    public static final SessionsApi SessionsApi = new zzbzt();
    public static final Api<Api.ApiOptions.NoOptions> HISTORY_API = zzbvv.API;
    public static final HistoryApi HistoryApi = new zzbyy();
    public static final Api<Api.ApiOptions.NoOptions> GOALS_API = zzbvq.API;
    public static final GoalsApi GoalsApi = new zzbyv();
    public static final Api<Api.ApiOptions.NoOptions> CONFIG_API = zzbvk.API;
    public static final ConfigApi ConfigApi = new zzbyq();
    public static final Api<Api.ApiOptions.NoOptions> BLE_API = zzbve.API;
    public static final BleApi BleApi = Build.VERSION.SDK_INT >= 18 ? new zzbyi() : new zzcaf();
    public static final Scope SCOPE_ACTIVITY_READ = new Scope("https://www.googleapis.com/auth/fitness.activity.read");
    public static final Scope SCOPE_ACTIVITY_READ_WRITE = new Scope("https://www.googleapis.com/auth/fitness.activity.write");
    public static final Scope SCOPE_LOCATION_READ = new Scope("https://www.googleapis.com/auth/fitness.location.read");
    public static final Scope SCOPE_LOCATION_READ_WRITE = new Scope("https://www.googleapis.com/auth/fitness.location.write");
    public static final Scope SCOPE_BODY_READ = new Scope("https://www.googleapis.com/auth/fitness.body.read");
    public static final Scope SCOPE_BODY_READ_WRITE = new Scope("https://www.googleapis.com/auth/fitness.body.write");
    public static final Scope SCOPE_NUTRITION_READ = new Scope("https://www.googleapis.com/auth/fitness.nutrition.read");
    public static final Scope SCOPE_NUTRITION_READ_WRITE = new Scope("https://www.googleapis.com/auth/fitness.nutrition.write");
    public static final String ACTION_TRACK = "vnd.google.fitness.TRACK";
    public static final String ACTION_VIEW = "vnd.google.fitness.VIEW";
    public static final String ACTION_VIEW_GOAL = "vnd.google.fitness.VIEW_GOAL";
    public static final String EXTRA_START_TIME = "vnd.google.fitness.start_time";
    public static final String EXTRA_END_TIME = "vnd.google.fitness.end_time";

    private Fitness() {
    }

    public static SensorsClient getSensorsClient(@NonNull Activity activity, GoogleSignInAccount googleSignInAccount) {
        return new SensorsClient(activity, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static SensorsClient getSensorsClient(@NonNull Context context, GoogleSignInAccount googleSignInAccount) {
        return new SensorsClient(context, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static RecordingClient getRecordingClient(@NonNull Activity activity, GoogleSignInAccount googleSignInAccount) {
        return new RecordingClient(activity, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static RecordingClient getRecordingClient(@NonNull Context context, GoogleSignInAccount googleSignInAccount) {
        return new RecordingClient(context, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static SessionsClient getSessionsClient(@NonNull Activity activity, GoogleSignInAccount googleSignInAccount) {
        return new SessionsClient(activity, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static SessionsClient getSessionsClient(@NonNull Context context, GoogleSignInAccount googleSignInAccount) {
        return new SessionsClient(context, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static HistoryClient getHistoryClient(@NonNull Activity activity, GoogleSignInAccount googleSignInAccount) {
        return new HistoryClient(activity, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static HistoryClient getHistoryClient(@NonNull Context context, GoogleSignInAccount googleSignInAccount) {
        return new HistoryClient(context, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static GoalsClient getGoalsClient(@NonNull Activity activity, GoogleSignInAccount googleSignInAccount) {
        return new GoalsClient(activity, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static GoalsClient getGoalsClient(@NonNull Context context, GoogleSignInAccount googleSignInAccount) {
        return new GoalsClient(context, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static ConfigClient getConfigClient(@NonNull Activity activity, GoogleSignInAccount googleSignInAccount) {
        return new ConfigClient(activity, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static ConfigClient getConfigClient(@NonNull Context context, GoogleSignInAccount googleSignInAccount) {
        return new ConfigClient(context, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static BleClient getBleClient(@NonNull Activity activity, GoogleSignInAccount googleSignInAccount) {
        return new BleClient(activity, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static BleClient getBleClient(@NonNull Context context, GoogleSignInAccount googleSignInAccount) {
        return new BleClient(context, FitnessOptions.zzb(googleSignInAccount).build());
    }

    public static long getStartTime(Intent intent, TimeUnit timeUnit) {
        long l = intent.getLongExtra(EXTRA_START_TIME, -1L);
        if (l == -1L) {
            return -1L;
        }
        return timeUnit.convert(l, TimeUnit.MILLISECONDS);
    }

    public static long getEndTime(Intent intent, TimeUnit timeUnit) {
        long l = intent.getLongExtra(EXTRA_END_TIME, -1L);
        if (l == -1L) {
            return -1L;
        }
        return timeUnit.convert(l, TimeUnit.MILLISECONDS);
    }
}

