/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.zzg;
import com.google.android.gms.fitness.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FitnessOptions
implements GoogleSignInOptionsExtension,
Api.ApiOptions.HasGoogleSignInAccountOptions {
    public static final int ACCESS_READ = 0;
    public static final int ACCESS_WRITE = 1;
    private final Map<Integer, List<DataType>> zzgzc;
    private final Set<Scope> zzgzd;
    private final GoogleSignInAccount zzgze;

    private FitnessOptions(Map<Integer, List<DataType>> map, GoogleSignInAccount googleSignInAccount) {
        this.zzgzc = map;
        this.zzgze = googleSignInAccount;
        ArrayList<Scope> arrayList = new ArrayList<Scope>();
        for (Map.Entry<Integer, List<DataType>> entry : map.entrySet()) {
            for (DataType dataType : entry.getValue()) {
                if (entry.getKey() == 0 && dataType.zzaqn() != null) {
                    arrayList.add(new Scope(dataType.zzaqn()));
                    continue;
                }
                if (entry.getKey() != 1 || dataType.zzaqo() == null) continue;
                arrayList.add(new Scope(dataType.zzaqo()));
            }
        }
        this.zzgzd = zzh.zzi(arrayList);
    }

    public GoogleSignInAccount getGoogleSignInAccount() {
        return this.zzgze;
    }

    public int getExtensionType() {
        return 3;
    }

    public Bundle toBundle() {
        return new Bundle();
    }

    @Nullable
    public List<Scope> getImpliedScopes() {
        return new ArrayList<Scope>(this.zzgzd);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder zzb(GoogleSignInAccount googleSignInAccount) {
        if (googleSignInAccount != null) {
            return new Builder(null).zzc(googleSignInAccount);
        }
        return new Builder(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FitnessOptions fitnessOptions = (FitnessOptions)object;
        return zzbg.equal(this.zzgzc, fitnessOptions.zzgzc) && zzbg.equal((Object)this.zzgze, (Object)fitnessOptions.zzgze);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgzc, this.zzgze});
    }

    /* synthetic */ FitnessOptions(Map map, GoogleSignInAccount googleSignInAccount, zzg zzg2) {
        this(map, googleSignInAccount);
    }

    public static final class Builder {
        private final Map<Integer, List<DataType>> map = new HashMap<Integer, List<DataType>>();
        private GoogleSignInAccount zzgze;

        private Builder() {
        }

        public final Builder addDataType(@NonNull DataType dataType) {
            return this.addDataType(dataType, 0);
        }

        public final Builder addDataType(@NonNull DataType dataType, int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException("vallie access types are FitnessOptions.ACCESS_READ or FitnessOptions,ACCESS_WRITE");
            }
            List<DataType> list = this.map.get(n);
            if (list == null) {
                list = new ArrayList<DataType>();
                this.map.put(n, list);
            }
            list.add(dataType);
            return this;
        }

        private final Builder zzc(@NonNull GoogleSignInAccount googleSignInAccount) {
            this.zzgze = googleSignInAccount;
            return this;
        }

        public final FitnessOptions build() {
            return new FitnessOptions(this.map, this.zzgze, null);
        }

        /* synthetic */ Builder(zzg zzg2) {
            this();
        }
    }
}

