/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends zzbfm
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzeck;
    private final long zzdvq;
    private final long zzgzz;
    private final Session zzgzp;
    private final int zzhaa;
    private final List<DataSet> zzhab;
    private final int zzhac;
    private boolean zzhad = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.zzeck = n;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.zzgzp = session;
        this.zzhaa = n2;
        this.zzhab = list;
        this.zzhac = n3;
        this.zzhad = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.zzdvq, rawBucket.zzgzz, rawBucket.zzgzp, rawBucket.zzhdk, Bucket.zza(rawBucket.zzhab, list), rawBucket.zzhac, rawBucket.zzhad);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdvq, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzz, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzgzp;
    }

    public String getActivity() {
        return zza.getName(this.zzhaa);
    }

    public final int zzaqc() {
        return this.zzhaa;
    }

    public List<DataSet> getDataSets() {
        return this.zzhab;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzhab) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzhac;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Bucket)) break block3;
                Bucket bucket = (Bucket)((Object)object);
                Bucket bucket2 = this;
                if (!(bucket2.zzdvq == bucket.zzdvq && bucket2.zzgzz == bucket.zzgzz && bucket2.zzhaa == bucket.zzhaa && zzbg.equal(bucket2.zzhab, bucket.zzhab) && bucket2.zzhac == bucket.zzhac && bucket2.zzhad == bucket.zzhad)) break block3;
            }
            return true;
        }
        return false;
    }

    public final boolean zza(Bucket bucket) {
        return this.zzdvq == bucket.zzdvq && this.zzgzz == bucket.zzgzz && this.zzhaa == bucket.zzhaa && this.zzhac == bucket.zzhac;
    }

    public final boolean zzaqd() {
        if (this.zzhad) {
            return true;
        }
        Iterator<DataSet> iterator = this.zzhab.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzaqd()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdvq, this.zzgzz, this.zzhaa, this.zzhac});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTime", (Object)this.zzdvq).zzg("endTime", (Object)this.zzgzz).zzg("activity", (Object)this.zzhaa).zzg("dataSets", this.zzhab).zzg("bucketType", (Object)Bucket.zzda(this.zzhac)).zzg("serverHasMoreData", (Object)this.zzhad).toString();
    }

    public static String zzda(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Bucket bucket = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (long)bucket.zzdvq);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)bucket.zzgzz);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)bucket.getSession(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)bucket.zzhaa);
        zzbfp.zzc((Parcel)parcel2, (int)5, bucket.getDataSets(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)bucket.getBucketType());
        zzbfp.zza((Parcel)parcel2, (int)7, (boolean)bucket.zzaqd());
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)bucket.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

