/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbfr;
import com.google.android.gms.internal.zzbut;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends zzbfm
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzgzh;
    private long zzhag;
    private long zzhah;
    private final Value[] zzhai;
    private DataSource zzhaj;
    private long zzhak;
    private long zzhal;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzh();

    DataPoint(int n, DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.versionCode = n;
        this.zzgzh = dataSource;
        this.zzhaj = dataSource2;
        this.zzhag = l;
        this.zzhah = l2;
        this.zzhai = valueArray;
        this.zzhak = l3;
        this.zzhal = l4;
    }

    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zzc(list, rawDataPoint.zzhdo), DataPoint.zzc(list, rawDataPoint.zzhdp), rawDataPoint);
    }

    private DataPoint(DataSource dataSource, DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzhdl, 0L), DataPoint.zza(rawDataPoint.zzhdm, 0L), rawDataPoint.zzhdn, dataSource2, DataPoint.zza(rawDataPoint.zzhdq, 0L), DataPoint.zza(rawDataPoint.zzhdr, 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private DataPoint(DataSource dataSource) {
        this.versionCode = 4;
        this.zzgzh = (DataSource)((Object)zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        List<Field> list = dataSource.getDataType().getFields();
        this.zzhai = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzhai[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzbfr.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public final DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzhag = timeUnit.toNanos(l);
        if (this.getDataType() == DataType.TYPE_LOCATION_SAMPLE && timeUnit.convert(1L, TimeUnit.MILLISECONDS) > 1L) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzhag = zzbut.zza(this.zzhag, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public final DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzhah = timeUnit.toNanos(l);
        this.zzhag = timeUnit.toNanos(l2);
        return this;
    }

    public final Value zzdb(int n) {
        DataType dataType = this.getDataType();
        if (n < 0 || n >= dataType.getFields().size()) {
            throw new IllegalArgumentException(String.format("fieldIndex %s is out of range for %s", new Object[]{n, dataType}));
        }
        return this.zzhai[n];
    }

    public final Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzhai[n];
    }

    public final Value[] zzaqf() {
        return this.zzhai;
    }

    public final DataPoint setFloatValues(float ... fArray) {
        this.zzdc(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzhai[i].setFloat(fArray[i]);
        }
        return this;
    }

    public final DataPoint setIntValues(int ... nArray) {
        this.zzdc(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzhai[i].setInt(nArray[i]);
        }
        return this;
    }

    private final void zzdc(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzbq.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public final DataType getDataType() {
        return this.zzgzh.getDataType();
    }

    public final DataSource getDataSource() {
        return this.zzgzh;
    }

    public final DataSource getOriginalDataSource() {
        if (this.zzhaj != null) {
            return this.zzhaj;
        }
        return this.zzgzh;
    }

    public final DataSource zzaqg() {
        return this.zzhaj;
    }

    public final long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhag, TimeUnit.NANOSECONDS);
    }

    public final long zzaqh() {
        return this.zzhak;
    }

    public final long zzaqi() {
        return this.zzhal;
    }

    public final long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhah, TimeUnit.NANOSECONDS);
    }

    public final long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhag, TimeUnit.NANOSECONDS);
    }

    public final void zzaqj() {
        DataSource dataSource = this.getDataSource();
        zzbq.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzbq.zzb((this.zzhag > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzbq.zzb((this.zzhah <= this.zzhag ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataPoint)) break block3;
                DataPoint dataPoint = (DataPoint)((Object)object);
                DataPoint dataPoint2 = this;
                if (!(zzbg.equal((Object)((Object)dataPoint2.zzgzh), (Object)((Object)dataPoint.zzgzh)) && dataPoint2.zzhag == dataPoint.zzhag && dataPoint2.zzhah == dataPoint.zzhah && Arrays.equals((Object[])dataPoint2.zzhai, (Object[])dataPoint.zzhai) && zzbg.equal((Object)((Object)dataPoint2.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource())))) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgzh, this.zzhag, this.zzhah});
    }

    public final String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzhai), this.zzhah, this.zzhag, this.zzhak, this.zzhal, this.zzgzh.toDebugString(), this.zzhaj != null ? this.zzhaj.toDebugString() : "N/A");
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataPoint dataPoint = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (Parcelable)dataPoint.getDataSource(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)dataPoint.zzhag);
        zzbfp.zza((Parcel)parcel2, (int)4, (long)dataPoint.zzhah);
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable[])dataPoint.zzhai, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (Parcelable)dataPoint.zzhaj, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (long)dataPoint.zzhak);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)dataPoint.versionCode);
        zzbfp.zza((Parcel)parcel2, (int)8, (long)dataPoint.zzhal);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    private static long zza(Long l, long l2) {
        if (l != null) {
            return l;
        }
        return 0L;
    }
}

