/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzab;
import com.google.android.gms.fitness.data.zzp;
import com.google.android.gms.fitness.data.zzr;
import com.google.android.gms.fitness.data.zzs;
import com.google.android.gms.fitness.data.zzx;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Goal
extends zzbfm {
    public static final int OBJECTIVE_TYPE_METRIC = 1;
    public static final int OBJECTIVE_TYPE_DURATION = 2;
    public static final int OBJECTIVE_TYPE_FREQUENCY = 3;
    private final int versionCode;
    private final long zzhcw;
    private final long zzhcx;
    private final List<Integer> zzhcy;
    private final Recurrence zzhcz;
    private final int zzhda;
    private final MetricObjective zzhdb;
    private final DurationObjective zzhdc;
    private final FrequencyObjective zzhdd;
    public static final Parcelable.Creator<Goal> CREATOR = new zzs();

    public long getCreateTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhcw, TimeUnit.NANOSECONDS);
    }

    public long getStartTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzhcz != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzhcz.zzhdh) {
                case 1: {
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzhcz.zzhdh;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzhcw, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzhcz != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzhcz.zzhdh) {
                case 1: {
                    calendar2.add(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.add(4, 1);
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.add(2, 1);
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzhcz.zzhdh;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzhcx, TimeUnit.NANOSECONDS);
    }

    @Nullable
    public String getActivityName() {
        if (this.zzhcy.isEmpty() || this.zzhcy.size() > 1) {
            return null;
        }
        return zza.getName(this.zzhcy.get(0));
    }

    public Recurrence getRecurrence() {
        return this.zzhcz;
    }

    public int getObjectiveType() {
        return this.zzhda;
    }

    private static String zzde(int n) {
        switch (n) {
            case 1: {
                return "metric";
            }
            case 2: {
                return "duration";
            }
            case 3: {
                return "frequency";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("invalid objective type value");
    }

    public MetricObjective getMetricObjective() {
        this.zzdf(1);
        return this.zzhdb;
    }

    public DurationObjective getDurationObjective() {
        this.zzdf(2);
        return this.zzhdc;
    }

    public FrequencyObjective getFrequencyObjective() {
        this.zzdf(3);
        return this.zzhdd;
    }

    Goal(int n, long l, long l2, List<Integer> list, Recurrence recurrence, int n2, MetricObjective metricObjective, DurationObjective durationObjective, FrequencyObjective frequencyObjective) {
        this.versionCode = n;
        this.zzhcw = l;
        this.zzhcx = l2;
        this.zzhcy = list;
        this.zzhcz = recurrence;
        this.zzhda = n2;
        this.zzhdb = metricObjective;
        this.zzhdc = durationObjective;
        this.zzhdd = frequencyObjective;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Goal)) break block3;
                Goal goal = (Goal)((Object)object);
                Goal goal2 = this;
                if (!(goal2.zzhcw == goal.zzhcw && goal2.zzhcx == goal.zzhcx && zzbg.equal(goal2.zzhcy, goal.zzhcy) && zzbg.equal((Object)((Object)goal2.zzhcz), (Object)((Object)goal.zzhcz)) && goal2.zzhda == goal.zzhda && zzbg.equal((Object)((Object)goal2.zzhdb), (Object)((Object)goal.zzhdb)) && zzbg.equal((Object)((Object)goal2.zzhdc), (Object)((Object)goal.zzhdc)) && zzbg.equal((Object)((Object)goal2.zzhdd), (Object)((Object)goal.zzhdd)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.zzhda;
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("activity", (Object)this.getActivityName()).zzg("recurrence", (Object)this.zzhcz).zzg("metricObjective", (Object)this.zzhdb).zzg("durationObjective", (Object)this.zzhdc).zzg("frequencyObjective", (Object)this.zzhdd).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Goal goal = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (long)goal.zzhcw);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)goal.zzhcx);
        zzbfp.zzd((Parcel)parcel2, (int)3, goal.zzhcy, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (Parcelable)goal.getRecurrence(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)goal.getObjectiveType());
        zzbfp.zza((Parcel)parcel2, (int)6, (Parcelable)goal.zzhdb, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)goal.zzhdc, (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)goal.versionCode);
        zzbfp.zza((Parcel)parcel2, (int)8, (Parcelable)goal.zzhdd, (int)n, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    private final void zzdf(int n) throws MismatchedGoalException {
        if (n != this.zzhda) {
            throw new MismatchedGoalException(String.format("%s goal does not have %s objective", Goal.zzde(this.zzhda), Goal.zzde(n)));
        }
    }

    public static class MismatchedGoalException
    extends IllegalStateException {
        public MismatchedGoalException(String string) {
            super(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ObjectiveType {
    }

    public static class FrequencyObjective
    extends zzbfm {
        private final int versionCode;
        private final int frequency;
        public static final Parcelable.Creator<FrequencyObjective> CREATOR = new zzr();

        public int getFrequency() {
            return this.frequency;
        }

        FrequencyObjective(int n, int n2) {
            this.versionCode = n;
            this.frequency = n2;
        }

        public FrequencyObjective(int n) {
            this(1, n);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FrequencyObjective)) break block3;
                    FrequencyObjective frequencyObjective = (FrequencyObjective)((Object)object);
                    if (this.frequency != frequencyObjective.frequency) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.frequency;
        }

        public String toString() {
            return zzbg.zzx((Object)((Object)this)).zzg("frequency", (Object)this.frequency).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            FrequencyObjective frequencyObjective = this;
            int n2 = zzbfp.zze((Parcel)parcel2);
            zzbfp.zzc((Parcel)parcel2, (int)1, (int)frequencyObjective.getFrequency());
            zzbfp.zzc((Parcel)parcel2, (int)1000, (int)frequencyObjective.versionCode);
            zzbfp.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class DurationObjective
    extends zzbfm {
        private final int versionCode;
        private final long zzhde;
        public static final Parcelable.Creator<DurationObjective> CREATOR = new zzp();

        public long getDuration(TimeUnit timeUnit) {
            return timeUnit.convert(this.zzhde, TimeUnit.NANOSECONDS);
        }

        DurationObjective(int n, long l) {
            this.versionCode = n;
            this.zzhde = l;
        }

        public DurationObjective(long l, TimeUnit timeUnit) {
            this(1, timeUnit.toNanos(l));
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DurationObjective)) break block3;
                    DurationObjective durationObjective = (DurationObjective)((Object)object);
                    if (!(this.zzhde == durationObjective.zzhde)) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.zzhde;
        }

        public String toString() {
            return zzbg.zzx((Object)((Object)this)).zzg("duration", (Object)this.zzhde).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            DurationObjective durationObjective = this;
            int n2 = zzbfp.zze((Parcel)parcel2);
            zzbfp.zza((Parcel)parcel2, (int)1, (long)durationObjective.zzhde);
            zzbfp.zzc((Parcel)parcel2, (int)1000, (int)durationObjective.versionCode);
            zzbfp.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class MetricObjective
    extends zzbfm {
        private final int versionCode;
        private final String zzhdf;
        private final double value;
        private final double zzhdg;
        public static final Parcelable.Creator<MetricObjective> CREATOR = new zzx();

        public String getDataTypeName() {
            return this.zzhdf;
        }

        public double getValue() {
            return this.value;
        }

        MetricObjective(int n, String string, double d, double d2) {
            this.versionCode = n;
            this.zzhdf = string;
            this.value = d;
            this.zzhdg = d2;
        }

        public MetricObjective(String string, double d) {
            this(1, string, d, 0.0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MetricObjective)) break block3;
                    MetricObjective metricObjective = (MetricObjective)((Object)object);
                    MetricObjective metricObjective2 = this;
                    if (!(zzbg.equal((Object)metricObjective2.zzhdf, (Object)metricObjective.zzhdf) && metricObjective2.value == metricObjective.value && metricObjective2.zzhdg == metricObjective.zzhdg)) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.zzhdf.hashCode();
        }

        public String toString() {
            return zzbg.zzx((Object)((Object)this)).zzg("dataTypeName", (Object)this.zzhdf).zzg("value", (Object)this.value).zzg("initialValue", (Object)this.zzhdg).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            MetricObjective metricObjective = this;
            int n2 = zzbfp.zze((Parcel)parcel2);
            zzbfp.zza((Parcel)parcel2, (int)1, (String)metricObjective.getDataTypeName(), (boolean)false);
            zzbfp.zza((Parcel)parcel2, (int)2, (double)metricObjective.getValue());
            zzbfp.zza((Parcel)parcel2, (int)3, (double)metricObjective.zzhdg);
            zzbfp.zzc((Parcel)parcel2, (int)1000, (int)metricObjective.versionCode);
            zzbfp.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class Recurrence
    extends zzbfm {
        public static final int UNIT_DAY = 1;
        public static final int UNIT_WEEK = 2;
        public static final int UNIT_MONTH = 3;
        private final int versionCode;
        private final int count;
        private final int zzhdh;
        public static final Parcelable.Creator<Recurrence> CREATOR = new zzab();

        public int getCount() {
            return this.count;
        }

        public int getUnit() {
            return this.zzhdh;
        }

        Recurrence(int n, int n2, int n3) {
            this.versionCode = n;
            this.count = n2;
            zzbq.checkState((n3 > 0 && n3 <= 3 ? 1 : 0) != 0);
            this.zzhdh = n3;
        }

        public Recurrence(int n, int n2) {
            this(1, n, n2);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Recurrence)) break block3;
                    Recurrence recurrence = (Recurrence)((Object)object);
                    Recurrence recurrence2 = this;
                    if (!(recurrence2.count == recurrence.count && recurrence2.zzhdh == recurrence.zzhdh)) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.zzhdh;
        }

        public String toString() {
            String string;
            zzbi zzbi2 = zzbg.zzx((Object)((Object)this)).zzg("count", (Object)this.count);
            switch (this.zzhdh) {
                case 1: {
                    string = "day";
                    break;
                }
                case 2: {
                    string = "week";
                    break;
                }
                case 3: {
                    string = "month";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid unit value");
                }
            }
            return zzbi2.zzg("unit", (Object)string).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Recurrence recurrence = this;
            int n2 = zzbfp.zze((Parcel)parcel2);
            zzbfp.zzc((Parcel)parcel2, (int)1, (int)recurrence.getCount());
            zzbfp.zzc((Parcel)parcel2, (int)2, (int)recurrence.getUnit());
            zzbfp.zzc((Parcel)parcel2, (int)1000, (int)recurrence.versionCode);
            zzbfp.zzai((Parcel)parcel2, (int)n2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RecurrenceUnit {
        }
    }
}

