/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzl;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzai;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends zzbfm {
    private final int versionCode;
    private final int format;
    private boolean zzhea;
    private float value;
    private String zzgcc;
    private Map<String, MapValue> zzheb;
    private int[] zzhec;
    private float[] zzhed;
    private byte[] zzhee;
    public static final Parcelable.Creator<Value> CREATOR = new zzai();

    public Value(int n) {
        this(3, n, false, 0.0f, null, null, null, null, null);
    }

    Value(int n, int n2, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        ArrayMap arrayMap;
        this.versionCode = n;
        this.format = n2;
        this.zzhea = bl;
        this.value = f;
        this.zzgcc = string;
        Bundle bundle2 = bundle;
        if (bundle2 == null) {
            arrayMap = null;
        } else {
            bundle2.setClassLoader(MapValue.class.getClassLoader());
            ArrayMap arrayMap2 = new ArrayMap(bundle2.size());
            for (String string2 : bundle2.keySet()) {
                arrayMap2.put(string2, (MapValue)bundle2.getParcelable(string2));
            }
            arrayMap = arrayMap2;
        }
        this.zzheb = arrayMap;
        this.zzhec = nArray;
        this.zzhed = fArray;
        this.zzhee = byArray;
    }

    public final void setInt(int n) {
        zzbq.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzhea = true;
        this.value = Float.intBitsToFloat(n);
    }

    public final void setFloat(float f) {
        zzbq.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzhea = true;
        this.value = f;
    }

    public final void setString(String string) {
        zzbq.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzhea = true;
        this.zzgcc = string;
    }

    public final void setKeyValue(String string, float f) {
        zzbq.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzhea = true;
        if (this.zzheb == null) {
            this.zzheb = new HashMap<String, MapValue>();
        }
        this.zzheb.put(string, new MapValue(2, f));
    }

    public final void clearKey(String string) {
        zzbq.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzheb != null) {
            this.zzheb.remove(string);
        }
    }

    public final void setActivity(String string) {
        this.setInt(zza.zzhc(string));
    }

    public final boolean isSet() {
        return this.zzhea;
    }

    public final int getFormat() {
        return this.format;
    }

    public final int asInt() {
        zzbq.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.value);
    }

    public final float asFloat() {
        zzbq.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.value;
    }

    public final String asString() {
        zzbq.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzgcc;
    }

    @Nullable
    public final Float getKeyValue(String string) {
        zzbq.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzheb != null && this.zzheb.containsKey(string)) {
            return Float.valueOf(this.zzheb.get(string).asFloat());
        }
        return null;
    }

    public final String asActivity() {
        return zza.getName(this.asInt());
    }

    public final boolean equals(Object object) {
        block18: {
            block17: {
                boolean bl;
                if (this == object) break block17;
                if (!(object instanceof Value)) break block18;
                Value value = (Value)((Object)object);
                Value value2 = this;
                if (value2.format == value.format && value2.zzhea == value.zzhea) {
                    switch (value2.format) {
                        case 1: {
                            if (value2.asInt() == value.asInt()) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 2: {
                            if (value2.value == value.value) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 3: {
                            bl = zzbg.equal((Object)value2.zzgcc, (Object)value.zzgcc);
                            break;
                        }
                        case 4: {
                            bl = zzbg.equal(value2.zzheb, value.zzheb);
                            break;
                        }
                        case 5: {
                            bl = Arrays.equals(value2.zzhec, value.zzhec);
                            break;
                        }
                        case 6: {
                            bl = Arrays.equals(value2.zzhed, value.zzhed);
                            break;
                        }
                        case 7: {
                            bl = Arrays.equals(value2.zzhee, value.zzhee);
                            break;
                        }
                        default: {
                            if (value2.value == value.value) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                    }
                } else {
                    bl = false;
                }
                if (!bl) break block18;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.value), this.zzgcc, this.zzheb, this.zzhec, this.zzhed, this.zzhee});
    }

    public final String toString() {
        if (!this.zzhea) {
            return "unset";
        }
        switch (this.format) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.value);
            }
            case 3: {
                return this.zzgcc;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzheb).toString();
            }
            case 5: {
                return Arrays.toString(this.zzhec);
            }
            case 6: {
                return Arrays.toString(this.zzhed);
            }
            case 7: {
                return zzl.zza((byte[])this.zzhee, (int)0, (int)this.zzhee.length, (boolean)false);
            }
        }
        return "unknown";
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Bundle bundle;
        Parcel parcel2 = parcel;
        Value value = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)value.getFormat());
        zzbfp.zza((Parcel)parcel2, (int)2, (boolean)value.isSet());
        zzbfp.zza((Parcel)parcel2, (int)3, (float)value.value);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)value.zzgcc, (boolean)false);
        Value value2 = value;
        if (value2.zzheb == null) {
            bundle = null;
        } else {
            Bundle bundle2 = new Bundle(value2.zzheb.size());
            for (Map.Entry<String, MapValue> entry : value2.zzheb.entrySet()) {
                bundle2.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
            }
            bundle = bundle2;
        }
        zzbfp.zza((Parcel)parcel2, (int)5, bundle, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (int[])value.zzhec, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (float[])value.zzhed, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)value.versionCode);
        zzbfp.zza((Parcel)parcel2, (int)8, (byte[])value.zzhee, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

