/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbww;
import com.google.android.gms.internal.zzbwx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zzbfm {
    public static final int NO_LIMIT = 0;
    private final int zzeck;
    private final List<DataType> zzgzy;
    private final List<DataSource> zzhgf;
    private final long zzdvq;
    private final long zzgzz;
    private final List<DataType> zzhgk;
    private final List<DataSource> zzhgl;
    private final int zzhac;
    private final long zzhgm;
    private final DataSource zzhgn;
    private final int zzhgo;
    private final boolean zzhgp;
    private final boolean zzhgq;
    private final zzbww zzhgr;
    private final List<Device> zzhgs;
    private final List<Integer> zzhgt;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzn();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.zzeck = n;
        this.zzgzy = list;
        this.zzhgf = list2;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.zzhgk = list3;
        this.zzhgl = list4;
        this.zzhac = n2;
        this.zzhgm = l3;
        this.zzhgn = dataSource;
        this.zzhgo = n3;
        this.zzhgp = bl;
        this.zzhgq = bl2;
        this.zzhgr = iBinder == null ? null : zzbwx.zzat(iBinder);
        this.zzhgs = list5 == null ? Collections.emptyList() : list5;
        this.zzhgt = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzgzy, builder.zzhgf, builder.zzdvq, builder.zzgzz, builder.zzhgk, builder.zzhgl, builder.zzhac, builder.zzhgm, builder.zzhgn, builder.zzhgo, false, builder.zzhgq, null, builder.zzhgs, builder.zzhgt);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zzbww zzbww2) {
        this(dataReadRequest.zzgzy, dataReadRequest.zzhgf, dataReadRequest.zzdvq, dataReadRequest.zzgzz, dataReadRequest.zzhgk, dataReadRequest.zzhgl, dataReadRequest.zzhac, dataReadRequest.zzhgm, dataReadRequest.zzhgn, dataReadRequest.zzhgo, dataReadRequest.zzhgp, dataReadRequest.zzhgq, zzbww2, dataReadRequest.zzhgs, dataReadRequest.zzhgt);
    }

    private DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zzbww zzbww2, List<Device> list5, List<Integer> list6) {
        this(6, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzbww2 == null ? null : zzbww2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdvq, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzz, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzgzy;
    }

    public List<DataSource> getDataSources() {
        return this.zzhgf;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzhgk;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzhgl;
    }

    public int getBucketType() {
        return this.zzhac;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhgm, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzhgn;
    }

    public int getLimit() {
        return this.zzhgo;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadRequest)) break block3;
                DataReadRequest dataReadRequest = (DataReadRequest)((Object)object);
                DataReadRequest dataReadRequest2 = this;
                if (!(dataReadRequest2.zzgzy.equals(dataReadRequest.zzgzy) && dataReadRequest2.zzhgf.equals(dataReadRequest.zzhgf) && dataReadRequest2.zzdvq == dataReadRequest.zzdvq && dataReadRequest2.zzgzz == dataReadRequest.zzgzz && dataReadRequest2.zzhac == dataReadRequest.zzhac && dataReadRequest2.zzhgl.equals(dataReadRequest.zzhgl) && dataReadRequest2.zzhgk.equals(dataReadRequest.zzhgk) && zzbg.equal((Object)((Object)dataReadRequest2.zzhgn), (Object)((Object)dataReadRequest.zzhgn)) && dataReadRequest2.zzhgm == dataReadRequest.zzhgm && dataReadRequest2.zzhgq == dataReadRequest.zzhgq && dataReadRequest2.zzhgo == dataReadRequest.zzhgo && dataReadRequest2.zzhgp == dataReadRequest.zzhgp && zzbg.equal((Object)dataReadRequest2.zzhgr, (Object)dataReadRequest.zzhgr) && zzbg.equal(dataReadRequest2.zzhgs, dataReadRequest.zzhgs) && zzbg.equal(dataReadRequest2.zzhgt, dataReadRequest.zzhgt))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhac, this.zzdvq, this.zzgzz});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzgzy.isEmpty()) {
            for (DataType zzbfm2 : this.zzgzy) {
                stringBuilder.append(zzbfm2.zzaqp()).append(" ");
            }
        }
        if (!this.zzhgf.isEmpty()) {
            for (DataSource dataSource : this.zzhgf) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzhac != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzda(this.zzhac));
            if (this.zzhgm > 0L) {
                stringBuilder.append(" >").append(this.zzhgm).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzhgk.isEmpty()) {
            for (DataType dataType : this.zzhgk) {
                stringBuilder.append(dataType.zzaqp()).append(" ");
            }
        }
        if (!this.zzhgl.isEmpty()) {
            for (DataSource dataSource : this.zzhgl) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzdvq, this.zzdvq, this.zzgzz, this.zzgzz));
        if (this.zzhgn != null) {
            stringBuilder.append("activities: ").append(this.zzhgn.toDebugString());
        }
        if (!this.zzhgt.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzhgt.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzdd(n)).append(" ");
            }
        }
        if (this.zzhgq) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public List<Integer> getFilteredDataQualityStandards() {
        return this.zzhgt;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadRequest dataReadRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, dataReadRequest.getDataTypes(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)2, dataReadRequest.getDataSources(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)dataReadRequest.zzdvq);
        zzbfp.zza((Parcel)parcel2, (int)4, (long)dataReadRequest.zzgzz);
        zzbfp.zzc((Parcel)parcel2, (int)5, dataReadRequest.getAggregatedDataTypes(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)6, dataReadRequest.getAggregatedDataSources(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)dataReadRequest.getBucketType());
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)dataReadRequest.zzeck);
        zzbfp.zza((Parcel)parcel2, (int)8, (long)dataReadRequest.zzhgm);
        zzbfp.zza((Parcel)parcel2, (int)9, (Parcelable)dataReadRequest.getActivityDataSource(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)10, (int)dataReadRequest.getLimit());
        zzbfp.zza((Parcel)parcel2, (int)12, (boolean)dataReadRequest.zzhgp);
        zzbfp.zza((Parcel)parcel2, (int)13, (boolean)dataReadRequest.zzhgq);
        DataReadRequest dataReadRequest2 = dataReadRequest;
        zzbfp.zza((Parcel)parcel2, (int)14, (IBinder)(dataReadRequest2.zzhgr == null ? null : dataReadRequest2.zzhgr.asBinder()), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)16, dataReadRequest.zzhgs, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)17, dataReadRequest.getFilteredDataQualityStandards(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataReadRequest(Builder builder, zzm zzm2) {
        this(builder);
    }

    public static class Builder {
        private List<DataType> zzgzy = new ArrayList<DataType>();
        private List<DataSource> zzhgf = new ArrayList<DataSource>();
        private List<DataType> zzhgk = new ArrayList<DataType>();
        private List<DataSource> zzhgl = new ArrayList<DataSource>();
        private DataSource zzhgn;
        private long zzdvq;
        private long zzgzz;
        private int zzhac = 0;
        private long zzhgm = 0L;
        private int zzhgo = 0;
        private boolean zzhgp = false;
        private boolean zzhgq = false;
        private final List<Device> zzhgs = new ArrayList<Device>();
        private final List<Integer> zzhgt = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder read(DataSource dataSource) {
            zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbq.checkArgument((!this.zzhgl.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzhgf.contains((Object)dataSource)) {
                this.zzhgf.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbq.zza((!this.zzhgk.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzgzy.contains((Object)dataType)) {
                this.zzgzy.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbq.zza((!this.zzhgf.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzbq.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzbq.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzhgl.contains((Object)dataSource)) {
                this.zzhgl.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbq.zza((!this.zzgzy.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzbq.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzbq.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzhgk.contains((Object)dataType)) {
                this.zzhgk.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhac == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhac});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhac = 1;
            this.zzhgm = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhac == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhac});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhac = 3;
            this.zzhgm = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbq.zzb((this.zzhac == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhac});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbq.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbq.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzhgn = dataSource;
            this.zzhac = 3;
            this.zzhgm = timeUnit.toMillis(n);
            return this;
        }

        public Builder addFilteredDataQualityStandard(int n) {
            zzbq.checkArgument((boolean)this.zzhgs.isEmpty(), (Object)"Cannot add data quality standard filter when filtering by device.");
            this.zzhgt.add(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhac == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhac});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhac = 4;
            this.zzhgm = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbq.zzb((this.zzhac == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhac});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbq.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbq.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzhgn = dataSource;
            this.zzhac = 4;
            this.zzhgm = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhac == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhac});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhac = 2;
            this.zzhgm = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzdvq = timeUnit.toMillis(l);
            this.zzgzz = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzhgq = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzhgo = n;
            return this;
        }

        public DataReadRequest build() {
            zzbq.zza((!this.zzhgf.isEmpty() || !this.zzgzy.isEmpty() || !this.zzhgl.isEmpty() || !this.zzhgk.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzbq.zza((this.zzdvq > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzdvq});
            zzbq.zza((this.zzgzz > 0L && this.zzgzz > this.zzdvq ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzgzz});
            boolean bl = this.zzhgl.isEmpty() && this.zzhgk.isEmpty();
            zzbq.zza((bl && this.zzhac == 0 || !bl && this.zzhac != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this, null);
        }
    }
}

