/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.fitness.request.zzz;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbyf;
import com.google.android.gms.internal.zzbyg;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zzbfm {
    private final int zzeck;
    private final long zzdvq;
    private final long zzgzz;
    private final DataSet zzhdx;
    private final zzbyf zzhgc;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzz();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzeck = n;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.zzhdx = dataSet;
        this.zzhgc = zzbyg.zzba(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzdvq, builder.zzgzz, builder.zzhdx, null);
    }

    private DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzeck = 1;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.zzhdx = dataSet;
        this.zzhgc = zzbyg.zzba(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzdvq, dataUpdateRequest.zzgzz, dataUpdateRequest.getDataSet(), iBinder);
    }

    public final long zzaae() {
        return this.zzdvq;
    }

    public final long zzaqu() {
        return this.zzgzz;
    }

    public DataSet getDataSet() {
        return this.zzhdx;
    }

    public IBinder getCallbackBinder() {
        if (this.zzhgc == null) {
            return null;
        }
        return this.zzhgc.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdvq, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzz, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataUpdateRequest)) break block3;
                DataUpdateRequest dataUpdateRequest = (DataUpdateRequest)((Object)object);
                DataUpdateRequest dataUpdateRequest2 = this;
                if (!(dataUpdateRequest2.zzdvq == dataUpdateRequest.zzdvq && dataUpdateRequest2.zzgzz == dataUpdateRequest.zzgzz && zzbg.equal((Object)((Object)dataUpdateRequest2.zzhdx), (Object)((Object)dataUpdateRequest.zzhdx)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdvq, this.zzgzz, this.zzhdx});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzdvq).zzg("endTimeMillis", (Object)this.zzgzz).zzg("dataSet", (Object)this.zzhdx).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataUpdateRequest dataUpdateRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (long)dataUpdateRequest.zzdvq);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)dataUpdateRequest.zzgzz);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)dataUpdateRequest.getDataSet(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (IBinder)dataUpdateRequest.getCallbackBinder(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)dataUpdateRequest.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataUpdateRequest(Builder builder, zzy zzy2) {
        this(builder);
    }

    public static class Builder {
        private long zzdvq;
        private long zzgzz;
        private DataSet zzhdx;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbq.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzdvq = timeUnit.toMillis(l);
            this.zzgzz = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzbq.checkNotNull((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzhdx = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            Builder builder = this;
            zzbq.zza((long)builder.zzdvq, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzbq.zza((long)builder.zzgzz, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzbq.checkNotNull((Object)((Object)builder.zzhdx), (Object)"Must set the data set");
            for (DataPoint dataPoint : builder.zzhdx.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                zzbq.zza((!(l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < builder.zzdvq || l2 != 0L && l2 > builder.zzgzz || l > builder.zzgzz || l < builder.zzdvq) ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, builder.zzdvq, builder.zzgzz});
            }
            return new DataUpdateRequest(this, null);
        }
    }
}

