/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzac;
import com.google.android.gms.fitness.request.zzad;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbuu;
import com.google.android.gms.internal.zzbxf;
import com.google.android.gms.internal.zzbxg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoalsReadRequest
extends zzbfm {
    private final int versionCode;
    private final zzbxf zzhhb;
    private final List<DataType> zzhhc;
    private final List<Integer> zzhhd;
    private final List<Integer> zzhcy;
    public static final Parcelable.Creator<GoalsReadRequest> CREATOR = new zzad();

    public List<DataType> getDataTypes() {
        return this.zzhhc;
    }

    public List<Integer> getObjectiveTypes() {
        if (this.zzhhd.isEmpty()) {
            return null;
        }
        return this.zzhhd;
    }

    public List<String> getActivityNames() {
        if (this.zzhcy.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : this.zzhcy) {
            arrayList.add(zza.getName(n));
        }
        return arrayList;
    }

    GoalsReadRequest(int n, IBinder iBinder, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this.versionCode = n;
        this.zzhhb = iBinder == null ? null : zzbxg.zzaw(iBinder);
        this.zzhhc = list;
        this.zzhhd = list2;
        this.zzhcy = list3;
    }

    private GoalsReadRequest(Builder builder) {
        this(null, builder.zzhhc, builder.zzhhd, builder.zzhcy);
    }

    public GoalsReadRequest(GoalsReadRequest goalsReadRequest, zzbxf zzbxf2) {
        this(zzbxf2, goalsReadRequest.getDataTypes(), goalsReadRequest.zzhhd, goalsReadRequest.zzhcy);
    }

    private GoalsReadRequest(zzbxf zzbxf2, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this(1, zzbxf2 == null ? null : zzbxf2.asBinder(), list, list2, list3);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GoalsReadRequest)) break block3;
                GoalsReadRequest goalsReadRequest = (GoalsReadRequest)((Object)object);
                GoalsReadRequest goalsReadRequest2 = this;
                if (!(zzbg.equal(goalsReadRequest2.zzhhc, goalsReadRequest.zzhhc) && zzbg.equal(goalsReadRequest2.zzhhd, goalsReadRequest.zzhhd) && zzbg.equal(goalsReadRequest2.zzhcy, goalsReadRequest.zzhcy))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhc, this.zzhhd, this.getActivityNames()});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("dataTypes", this.zzhhc).zzg("objectiveTypes", this.zzhhd).zzg("activities", this.getActivityNames()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoalsReadRequest goalsReadRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (IBinder)goalsReadRequest.zzhhb.asBinder(), (boolean)false);
        zzbfp.zzd((Parcel)parcel2, (int)2, goalsReadRequest.getDataTypes(), (boolean)false);
        zzbfp.zzd((Parcel)parcel2, (int)3, goalsReadRequest.zzhhd, (boolean)false);
        zzbfp.zzd((Parcel)parcel2, (int)4, goalsReadRequest.zzhcy, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)goalsReadRequest.versionCode);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ GoalsReadRequest(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private final List<DataType> zzhhc = new ArrayList<DataType>();
        private final List<Integer> zzhhd = new ArrayList<Integer>();
        private final List<Integer> zzhcy = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder addDataType(DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzhhc.contains((Object)dataType)) {
                this.zzhhc.add(dataType);
            }
            return this;
        }

        public Builder addActivity(String string) {
            int n = zza.zzhc(string);
            zzbq.zza((n != 4 ? 1 : 0) != 0, (Object)"Attempting to add an unknown activity");
            zzbuu.zza(n, this.zzhcy);
            return this;
        }

        public Builder addObjectiveType(int n) {
            zzbq.zza((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Attempting to add an invalid objective type");
            if (!this.zzhhd.contains(n)) {
                this.zzhhd.add(n);
            }
            return this;
        }

        public GoalsReadRequest build() {
            zzbq.zza((!this.zzhhc.isEmpty() ? 1 : 0) != 0, (Object)"At least one data type should be specified.");
            return new GoalsReadRequest(this, null);
        }
    }
}

