/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzaq;
import com.google.android.gms.location.LocationRequest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzhbr;
    private final DataType zzhbs;
    private final long zzhdy;
    private final long zzhhl;
    private final long zzhhk;
    private final int zzhdz;
    private final LocationRequest zzhhp;
    private final long zzhhq;

    private SensorRequest(Builder builder) {
        this.zzhbr = builder.zzhbr;
        this.zzhbs = builder.zzhbs;
        this.zzhdy = builder.zzhdy;
        this.zzhhl = builder.zzhhl;
        this.zzhhk = builder.zzhhk;
        this.zzhdz = builder.zzhdz;
        this.zzhhp = null;
        this.zzhhq = builder.zzhhq;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        int n;
        this.zzhhp = locationRequest;
        this.zzhdy = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzhhl = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzhhk = this.zzhdy;
        this.zzhbs = dataSource.getDataType();
        switch (locationRequest.getPriority()) {
            case 100: {
                n = 3;
                break;
            }
            case 104: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.zzhdz = n;
        this.zzhbr = dataSource;
        long l = locationRequest.getExpirationTime();
        if (l == Long.MAX_VALUE) {
            this.zzhhq = Long.MAX_VALUE;
            return;
        }
        this.zzhhq = TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    public DataSource getDataSource() {
        return this.zzhbr;
    }

    public DataType getDataType() {
        return this.zzhbs;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhdy, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhl, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhk, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzhdz;
    }

    public final long zzaqw() {
        return this.zzhhq;
    }

    public String toString() {
        return zzbg.zzx((Object)this).zzg("dataSource", (Object)this.zzhbr).zzg("dataType", (Object)this.zzhbs).zzg("samplingRateMicros", (Object)this.zzhdy).zzg("deliveryLatencyMicros", (Object)this.zzhhk).zzg("timeOutMicros", (Object)this.zzhhq).toString();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SensorRequest)) break block3;
                SensorRequest sensorRequest = (SensorRequest)object;
                SensorRequest sensorRequest2 = this;
                if (!(zzbg.equal((Object)((Object)sensorRequest2.zzhbr), (Object)((Object)sensorRequest.zzhbr)) && zzbg.equal((Object)((Object)sensorRequest2.zzhbs), (Object)((Object)sensorRequest.zzhbs)) && sensorRequest2.zzhdy == sensorRequest.zzhdy && sensorRequest2.zzhhl == sensorRequest.zzhhl && sensorRequest2.zzhhk == sensorRequest.zzhhk && sensorRequest2.zzhdz == sensorRequest.zzhdz && zzbg.equal((Object)sensorRequest2.zzhhp, (Object)sensorRequest.zzhhp) && sensorRequest2.zzhhq == sensorRequest.zzhhq)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhbr, this.zzhbs, this.zzhdy, this.zzhhl, this.zzhhk, this.zzhdz, this.zzhhp, this.zzhhq});
    }

    /* synthetic */ SensorRequest(Builder builder, zzaq zzaq2) {
        this(builder);
    }

    public static class Builder {
        private DataSource zzhbr;
        private DataType zzhbs;
        private long zzhdy = -1L;
        private long zzhhl = 0L;
        private long zzhhk = 0L;
        private boolean zzhhr = false;
        private int zzhdz = 2;
        private long zzhhq = Long.MAX_VALUE;

        public Builder() {
        }

        public Builder setDataSource(DataSource dataSource) {
            this.zzhbr = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzhbs = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzbq.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzhdy = timeUnit.toMicros(l);
            if (!this.zzhhr) {
                this.zzhhl = this.zzhdy / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzbq.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzhhr = true;
            this.zzhhl = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzbq.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzhhk = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            int n2;
            switch (n) {
                case 1: 
                case 3: {
                    n2 = n;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            this.zzhdz = n2;
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzbq.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzhhq = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzbq.zza((this.zzhbr != null || this.zzhbs != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzbq.zza((this.zzhbs == null || this.zzhbr == null || this.zzhbs.equals((Object)this.zzhbr.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this, null);
        }
    }
}

