/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzat;
import com.google.android.gms.fitness.request.zzau;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbut;
import com.google.android.gms.internal.zzbyf;
import com.google.android.gms.internal.zzbyg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends zzbfm {
    private final int versionCode;
    private final Session zzhhs;
    private final List<DataSet> zzhht;
    private final List<DataPoint> zzhhu;
    private final zzbyf zzhhv;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzau();

    SessionInsertRequest(int n, Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.versionCode = n;
        this.zzhhs = session;
        this.zzhht = Collections.unmodifiableList(list);
        this.zzhhu = Collections.unmodifiableList(list2);
        this.zzhhv = zzbyg.zzba(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzhhs, builder.zzhht, builder.zzhhu, null);
    }

    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzbyf zzbyf2) {
        this(sessionInsertRequest.zzhhs, sessionInsertRequest.zzhht, sessionInsertRequest.zzhhu, zzbyf2);
    }

    private SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, zzbyf zzbyf2) {
        this.versionCode = 3;
        this.zzhhs = session;
        this.zzhht = Collections.unmodifiableList(list);
        this.zzhhu = Collections.unmodifiableList(list2);
        this.zzhhv = zzbyf2;
    }

    public Session getSession() {
        return this.zzhhs;
    }

    public List<DataSet> getDataSets() {
        return this.zzhht;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzhhu;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof SessionInsertRequest)) break block3;
                SessionInsertRequest sessionInsertRequest = (SessionInsertRequest)((Object)object);
                SessionInsertRequest sessionInsertRequest2 = this;
                if (!(zzbg.equal((Object)((Object)sessionInsertRequest2.zzhhs), (Object)((Object)sessionInsertRequest.zzhhs)) && zzbg.equal(sessionInsertRequest2.zzhht, sessionInsertRequest.zzhht) && zzbg.equal(sessionInsertRequest2.zzhhu, sessionInsertRequest.zzhhu))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhs, this.zzhht, this.zzhhu});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("session", (Object)this.zzhhs).zzg("dataSets", this.zzhht).zzg("aggregateDataPoints", this.zzhhu).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionInsertRequest sessionInsertRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (Parcelable)sessionInsertRequest.getSession(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)2, sessionInsertRequest.getDataSets(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)3, sessionInsertRequest.getAggregateDataPoints(), (boolean)false);
        SessionInsertRequest sessionInsertRequest2 = sessionInsertRequest;
        zzbfp.zza((Parcel)parcel2, (int)4, (IBinder)(sessionInsertRequest2.zzhhv == null ? null : sessionInsertRequest2.zzhhv.asBinder()), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)sessionInsertRequest.versionCode);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionInsertRequest(Builder builder, zzat zzat2) {
        this(builder);
    }

    public static class Builder {
        private Session zzhhs;
        private List<DataSet> zzhht = new ArrayList<DataSet>();
        private List<DataPoint> zzhhu = new ArrayList<DataPoint>();
        private List<DataSource> zzhhw = new ArrayList<DataSource>();

        public Builder() {
        }

        public Builder setSession(Session session) {
            this.zzhhs = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzbq.checkArgument((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzbq.zza((!this.zzhhw.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            zzbq.checkArgument((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzhhw.add(dataSource);
            this.zzhht.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzbq.checkArgument((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzbq.zza((!this.zzhhw.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zzb(dataPoint);
            this.zzhhw.add(dataSource);
            this.zzhhu.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzbq.zza((this.zzhhs != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzbq.zza((this.zzhhs.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            Builder builder = this;
            Iterator<zzbfm> iterator = builder.zzhht.iterator();
            while (iterator.hasNext()) {
                for (DataPoint dataPoint : iterator.next().getDataPoints()) {
                    builder.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : builder.zzhhu) {
                builder.zzd(dataPoint);
            }
            return new SessionInsertRequest(this, null);
        }

        private final void zzd(DataPoint dataPoint) {
            DataPoint dataPoint2 = dataPoint;
            Builder builder = this;
            long l = builder.zzhhs.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = builder.zzhhs.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint2.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzbut.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbq.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (dataPoint2.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint2.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
            dataPoint2 = dataPoint;
            builder = this;
            l = builder.zzhhs.getStartTime(TimeUnit.NANOSECONDS);
            l2 = builder.zzhhs.getEndTime(TimeUnit.NANOSECONDS);
            l3 = dataPoint2.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint2.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzbut.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbq.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (l4 != dataPoint2.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint2.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }
    }
}

