/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.fitness.data.BleDevice;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zza;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BleDevicesResult
extends zzbfm
implements Result {
    private final int zzeck;
    private final List<BleDevice> zzhih;
    private final Status mStatus;
    public static final Parcelable.Creator<BleDevicesResult> CREATOR = new zza();

    BleDevicesResult(int n, List<BleDevice> list, Status status) {
        this.zzeck = n;
        this.zzhih = Collections.unmodifiableList(list);
        this.mStatus = status;
    }

    private BleDevicesResult(List<BleDevice> list, Status status) {
        this.zzeck = 3;
        this.zzhih = Collections.unmodifiableList(list);
        this.mStatus = status;
    }

    public static BleDevicesResult zzac(Status status) {
        return new BleDevicesResult(Collections.emptyList(), status);
    }

    public List<BleDevice> getClaimedBleDevices() {
        return this.zzhih;
    }

    public List<BleDevice> getClaimedBleDevices(DataType dataType) {
        ArrayList<BleDevice> arrayList = new ArrayList<BleDevice>();
        for (BleDevice bleDevice : this.zzhih) {
            if (!bleDevice.getDataTypes().contains((Object)dataType)) continue;
            arrayList.add(bleDevice);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BleDevicesResult)) break block3;
                BleDevicesResult bleDevicesResult = (BleDevicesResult)((Object)object);
                BleDevicesResult bleDevicesResult2 = this;
                if (!(bleDevicesResult2.mStatus.equals((Object)bleDevicesResult.mStatus) && zzbg.equal(bleDevicesResult2.zzhih, bleDevicesResult.zzhih))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzhih});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("status", (Object)this.mStatus).zzg("bleDevices", this.zzhih).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        BleDevicesResult bleDevicesResult = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, bleDevicesResult.getClaimedBleDevices(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)bleDevicesResult.getStatus(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)bleDevicesResult.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

