/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zzd;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataSourcesResult
extends zzbfm
implements Result {
    private final int versionCode;
    private final List<DataSource> zzhim;
    private final Status zzead;
    public static final Parcelable.Creator<DataSourcesResult> CREATOR = new zzd();

    DataSourcesResult(int n, List<DataSource> list, Status status) {
        this.versionCode = n;
        this.zzhim = Collections.unmodifiableList(list);
        this.zzead = status;
    }

    public DataSourcesResult(List<DataSource> list, Status status) {
        this.versionCode = 3;
        this.zzhim = Collections.unmodifiableList(list);
        this.zzead = status;
    }

    public List<DataSource> getDataSources() {
        return this.zzhim;
    }

    public List<DataSource> getDataSources(DataType dataType) {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        for (DataSource dataSource : this.zzhim) {
            if (!dataSource.getDataType().equals((Object)dataType)) continue;
            arrayList.add(dataSource);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzead;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataSourcesResult)) break block3;
                DataSourcesResult dataSourcesResult = (DataSourcesResult)((Object)object);
                DataSourcesResult dataSourcesResult2 = this;
                if (!(dataSourcesResult2.zzead.equals((Object)dataSourcesResult.zzead) && zzbg.equal(dataSourcesResult2.zzhim, dataSourcesResult.zzhim))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzead, this.zzhim});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("status", (Object)this.zzead).zzg("dataSources", this.zzhim).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSourcesResult dataSourcesResult = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, dataSourcesResult.getDataSources(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)dataSourcesResult.getStatus(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)dataSourcesResult.versionCode);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

